<?php
// app/Views/admin/management_partners_create.php
?>
<div class="container py-2">
  <h2 class="h5 mb-3"><i class="bi bi-people me-2"></i>Add Channel Partner</h2>
  <form method="post" action="/admin/management/partners/store">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
    <div class="row g-3">
      <div class="col-md-6">
        <label class="form-label">Partner/Company Name</label>
        <input type="text" class="form-control" name="name" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Contact Email</label>
        <input type="email" class="form-control" name="email" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Contact Person Name</label>
        <input type="text" class="form-control" name="contact_person" placeholder="e.g. John Doe">
      </div>
      <div class="col-md-4">
        <label class="form-label">Mobile Number</label>
        <input type="text" class="form-control" name="contact_mobile" placeholder="e.g. +66 98 765 4321">
      </div>
      <div class="col-md-2">
        <label class="form-label">WhatsApp</label>
        <input type="text" class="form-control" name="contact_whatsapp" placeholder="WhatsApp number">
      </div>
      <div class="col-md-2">
        <label class="form-label">LINE ID</label>
        <input type="text" class="form-control" name="contact_line" placeholder="Line ID">
      </div>
      <div class="col-12"><hr class="my-1"></div>
      <div class="col-12">
        <span class="fw-semibold text-muted">Address</span>
      </div>
      <div class="col-md-6">
        <label class="form-label">Address</label>
        <input type="text" class="form-control" name="address_line" placeholder="Street, Building, etc." required>
      </div>
      <div class="col-md-3">
        <label class="form-label">City</label>
        <input type="text" class="form-control" name="city" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">State/Province</label>
        <input type="text" class="form-control" name="state">
      </div>
      <div class="col-md-3">
        <label class="form-label">Pincode/ZIP</label>
        <input type="text" class="form-control" name="pincode">
      </div>
      <div class="col-md-3">
        <label class="form-label">Country</label>
        <input type="text" class="form-control" name="country" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Login Password</label>
        <input type="password" class="form-control" name="password" minlength="6" required>
        <div class="form-text">A login will be created with role "Channel Partner".</div>
      </div>
      <div class="col-md-3">
        <label class="form-label">Default Margin % (for B2B agents)</label>
        <input type="number" step="0.01" min="0" max="30" class="form-control" name="default_margin_percent" placeholder="e.g. 5.00">
        <div class="form-text">If set, agent price will increase by this %; the increase counts as partner margin.</div>
      </div>
      <div class="col-md-3">
        <label class="form-label">Fallback Share % (from system profit)</label>
        <input type="number" step="0.01" min="0" max="30" class="form-control" name="fallback_share_percent" placeholder="e.g. 20.00">
        <div class="form-text">Used when partner hasn't set margin; share is taken from our profit.</div>
      </div>
      <div class="col-12">
        <label class="form-label">Notes (optional)</label>
        <textarea class="form-control" name="notes" rows="2"></textarea>
      </div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary" type="submit">Create Partner</button>
      <a href="/admin" class="btn btn-outline-secondary">Cancel</a>
    </div>
  </form>
</div>
