<?php /** @var array $agent */ /** @var array|null $partner */ ?>
<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">Agent Details</h4>
    <div class="d-flex gap-2">
      <a class="btn btn-sm btn-secondary" href="/admin/management/agents"><i class="bi bi-arrow-left"></i> Back</a>
      <a class="btn btn-sm btn-primary" href="/users/edit?id=<?= (int)$agent['id'] ?>"><i class="bi bi-pencil-square"></i> Edit</a>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-md-6">
      <div class="card">
        <div class="card-body">
          <h6 class="text-muted">Basic Info</h6>
          <dl class="row mb-0">
            <dt class="col-sm-4">ID</dt><dd class="col-sm-8"><?= (int)$agent['id'] ?></dd>
            <dt class="col-sm-4">Name</dt><dd class="col-sm-8"><?= htmlspecialchars($agent['name'] ?? '') ?></dd>
            <dt class="col-sm-4">Email</dt><dd class="col-sm-8"><?= htmlspecialchars($agent['email'] ?? '') ?></dd>
            <dt class="col-sm-4">Status</dt><dd class="col-sm-8"><span class="badge bg-<?= ($agent['status']==='Active'?'success':'secondary') ?>"><?= htmlspecialchars($agent['status'] ?? '') ?></span></dd>
            <?php $awb = (float)($agent['wallet_balance'] ?? 0); ?>
            <dt class="col-sm-4">Wallet</dt>
            <dd class="col-sm-8">
              <span class="badge bg-<?= $awb > 0 ? 'success' : 'secondary' ?>"><?= number_format($awb, 2) ?></span>
            </dd>
          </dl>
        </div>
      </div>
    </div>
    <div class="col-md-6">
      <div class="card">
        <div class="card-body">
          <h6 class="text-muted">Profile</h6>
          <dl class="row mb-0">
            <dt class="col-sm-4">Company</dt><dd class="col-sm-8"><?= htmlspecialchars($agent['company'] ?? '') ?></dd>
            <dt class="col-sm-4">Phone</dt><dd class="col-sm-8"><?= htmlspecialchars($agent['phone'] ?? '') ?></dd>
            <dt class="col-sm-4">City</dt><dd class="col-sm-8"><?= htmlspecialchars($agent['city'] ?? '') ?></dd>
            <dt class="col-sm-4">Country</dt><dd class="col-sm-8"><?= htmlspecialchars($agent['country'] ?? '') ?></dd>
            <dt class="col-sm-4">Commission %</dt><dd class="col-sm-8"><?= number_format((float)($agent['commission_percent'] ?? 0), 2) ?></dd>
          </dl>
        </div>
      </div>
    </div>

    <div class="col-12">
      <div class="card">
        <div class="card-body">
          <h6 class="text-muted">Channel Partner</h6>
          <?php if ($partner): ?>
            <p class="mb-0"><a href="/admin/management/partners/view?id=<?= (int)$partner['id'] ?>" class="text-decoration-none"><i class="bi bi-people me-1"></i><?= htmlspecialchars($partner['name'] ?? '') ?></a></p>
          <?php else: ?>
            <p class="text-muted mb-0">No channel partner linked.</p>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>
