<?php
// app/Views/admin/management_agents_create.php
?>
<div class="container py-2">
  <h2 class="h5 mb-3"><i class="bi bi-person-plus me-2"></i>Add B2B Agent</h2>
  <style>
    .section-title { font-weight: 600; color: #334155; }
    .card-like { background:#fff; border:1px solid #e5e7eb; border-radius:10px; padding:16px; box-shadow:0 1px 2px rgba(0,0,0,.06); }
    .action-bar { position:sticky; bottom:0; background:#fff; padding:12px 0; border-top:1px solid #e5e7eb; z-index:5; }
    .form-label .info { color:#64748b; cursor:help; }
  </style>
  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-warning py-2 mb-3"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>
  <form method="post" action="/users/store" enctype="multipart/form-data">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
    <input type="hidden" name="role" value="B2B Agent">
    <input type="hidden" name="status" value="Active">
    <?php
      // KYC settings (with safe defaults if not provided)
      $agentKyc = $agentKyc ?? [];
      $K_PROFILE_EN = $agentKyc['profile_photo']['enabled'] ?? true;
      $K_PROFILE_REQ = $agentKyc['profile_photo']['required'] ?? true;
      $K_BIZ_EN = $agentKyc['business_card']['enabled'] ?? true;
      $K_BIZ_REQ = $agentKyc['business_card']['required'] ?? true;
      $K_SELFIE_EN = $agentKyc['selfie']['enabled'] ?? true;
      $K_SELFIE_REQ = $agentKyc['selfie']['required'] ?? true;
      $K_REG_SP_EN = $agentKyc['reg_certificate_sp']['enabled'] ?? true;
      $K_REG_SP_REQ = $agentKyc['reg_certificate_sp']['required'] ?? false;
      $K_PART_LLP_EN = $agentKyc['partnership_deed_llp']['enabled'] ?? true;
      $K_PART_LLP_REQ = $agentKyc['partnership_deed_llp']['required'] ?? false;
      $K_INC_CO_EN = $agentKyc['incorp_cert_company']['enabled'] ?? true;
      $K_INC_CO_REQ = $agentKyc['incorp_cert_company']['required'] ?? false;
      $K_ADDR_FR_EN = $agentKyc['address_proof_freelancer']['enabled'] ?? true;
      $K_ADDR_FR_REQ = $agentKyc['address_proof_freelancer']['required'] ?? true;
      // Government ID
      $K_GID_EN = $agentKyc['gov_id']['enabled'] ?? true;
      $K_GID_REQ_TYPE = $agentKyc['gov_id']['require_type'] ?? true;
      $K_GID_REQ_NUMBER = $agentKyc['gov_id']['require_number'] ?? true;
      $K_GID_REQ_FRONT = $agentKyc['gov_id']['require_front'] ?? true;
      $K_GID_BACK_EN = $agentKyc['gov_id']['back_enabled'] ?? true;
      $K_GID_REQ_BACK = $agentKyc['gov_id']['require_back'] ?? false;
      // Registration
      $K_IATA_EN = $agentKyc['registration']['iata_enabled'] ?? true;
      $K_IATA_REQ_YES = $agentKyc['registration']['iata_code_required_on_yes'] ?? true;
      $K_GST_NUM_EN = $agentKyc['registration']['gst_number']['enabled'] ?? true;
      $K_GST_NUM_REQ = $agentKyc['registration']['gst_number']['required'] ?? false;
      $K_GST_COM_EN = $agentKyc['registration']['gst_company']['enabled'] ?? true;
      $K_GST_COM_REQ = $agentKyc['registration']['gst_company']['required'] ?? false;
      // Business info
      $K_AGENCY_EN = $agentKyc['business_info']['agency_name']['enabled'] ?? true;
      $K_AGENCY_REQ_NONF = $agentKyc['business_info']['agency_name']['required_non_freelancer'] ?? false;
      // Financials
      $K_COMM_EN = $agentKyc['financials']['commission']['enabled'] ?? true;
      $K_COMM_DEF = $agentKyc['financials']['commission']['default'] ?? 0;
      $K_CREDIT_EN = $agentKyc['financials']['credit_limit']['enabled'] ?? true;
      $K_CREDIT_DEF = $agentKyc['financials']['credit_limit']['default'] ?? 0;
    ?>
    <div class="card-like">
      <div class="row g-3">
      <div class="col-12">
        <label class="form-label d-block mb-1">Business Type</label>
        <?php $bt = $_SESSION['old']['business_type'] ?? 'freelancer'; ?>
        <div class="d-flex flex-wrap gap-2">
          <label class="btn btn-outline-secondary btn-sm <?= $bt==='freelancer'?'active':''; ?>">
            <input type="radio" name="business_type" value="freelancer" class="form-check-input me-1" <?= $bt==='freelancer'?'checked':''; ?>> Freelancer
          </label>
          <label class="btn btn-outline-secondary btn-sm <?= $bt==='sole_proprietor'?'active':''; ?>">
            <input type="radio" name="business_type" value="sole_proprietor" class="form-check-input me-1" <?= $bt==='sole_proprietor'?'checked':''; ?>> Sole Proprietor
          </label>
          <label class="btn btn-outline-secondary btn-sm <?= $bt==='partnership'?'active':''; ?>">
            <input type="radio" name="business_type" value="partnership" class="form-check-input me-1" <?= $bt==='partnership'?'checked':''; ?>> Partnership/LLP
          </label>
          <label class="btn btn-outline-secondary btn-sm <?= $bt==='company'?'active':''; ?>">
            <input type="radio" name="business_type" value="company" class="form-check-input me-1" <?= $bt==='company'?'checked':''; ?>> Company
          </label>
        </div>
      </div>
      <div class="col-12 mt-2"><span class="section-title">Account</span></div>
      <div class="col-md-4">
        <label class="form-label">Full Name</label>
        <div class="input-group">
          <?php $title = $_SESSION['old']['title'] ?? 'Mr'; ?>
          <select name="title" class="form-select" style="max-width:120px" autocomplete="honorific-prefix">
            <option <?= $title==='Mr'?'selected':''; ?>>Mr</option>
            <option <?= $title==='Ms'?'selected':''; ?>>Ms</option>
            <option <?= $title==='Mrs'?'selected':''; ?>>Mrs</option>
          </select>
          <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['name'] ?? '') ?>" autocomplete="name" required>
        </div>
      </div>
      <div class="col-md-4">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['email'] ?? '') ?>" autocomplete="email" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Password</label>
        <input type="password" name="password" class="form-control" autocomplete="new-password" required>
      </div>
      <div class="col-12 mt-1"><span class="section-title">Business</span></div>
      <div class="col-md-4" id="grp_agency_name" style="<?= $K_AGENCY_EN ? '' : 'display:none;' ?>">
        <label class="form-label">Agency Name (if applicable) <i class="bi bi-info-circle small info" data-bs-toggle="tooltip" title="Visible for non‑Freelancer business types."></i></label>
        <input type="text" name="agency_name" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['agency_name'] ?? '') ?>" placeholder="Your agency name (leave blank for Freelancer)" autocomplete="organization">
        <div class="form-text">Shown when Business Type is not Freelancer.</div>
      </div>
      <div class="col-md-4">
        <label class="form-label">Company — Your Agency Name <i class="bi bi-info-circle small info" data-bs-toggle="tooltip" title="We use this to display your agency on invoices and communication."></i></label>
        <input type="text" name="agent_company" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['agent_company'] ?? '') ?>" placeholder="e.g., Stellar Travels Pvt Ltd" autocomplete="organization" required>
        <div class="form-text">This may appear on invoices and partner-facing areas.</div>
      </div>
      <div class="col-md-4">
        <label class="form-label">Phone / WhatsApp</label>
        <input type="text" name="agent_phone" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['agent_phone'] ?? '') ?>" placeholder="e.g., +91 98765 43210" autocomplete="tel" required>
      </div>
      <div class="col-12"><hr class="my-2"></div>
      <div class="col-12"><span class="section-title">Address</span></div>
      <div class="col-md-3">
        <label class="form-label">Country</label>
        <?php $oldCountry = $_SESSION['old']['country'] ?? ''; ?>
        <select name="country" class="form-select" id="countrySelect" autocomplete="country" required>
          <option value="">Select country</option>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">State</label>
        <?php $oldState = $_SESSION['old']['state'] ?? ''; ?>
        <select name="state" class="form-select" id="stateSelect" autocomplete="address-level1" disabled>
          <option value="">Select state</option>
        </select>
        <input type="text" name="state" class="form-control d-none mt-2" id="stateText" placeholder="Type state/province" value="<?= htmlspecialchars($oldState) ?>" autocomplete="address-level1">
      </div>
      <div class="col-md-3">
        <label class="form-label">City</label>
        <input type="text" name="city" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['city'] ?? '') ?>" autocomplete="address-level2" required>
      </div>
      <div class="col-md-2">
        <label class="form-label">Pincode</label>
        <input type="text" name="pincode" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['pincode'] ?? '') ?>" autocomplete="postal-code" required>
      </div>
      <div class="col-md-10">
        <label class="form-label">Address</label>
        <input type="text" name="address_line" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['address_line'] ?? '') ?>" autocomplete="address-line1" required>
      </div>
      <div class="col-12"><hr class="my-2"></div>
      <div class="col-12"><span class="section-title">Business Registration</span></div>
      <div class="col-md-3" id="grp_iata_block" style="<?= $K_IATA_EN ? '' : 'display:none;' ?>">
        <label class="form-label">IATA Registered</label>
        <?php $iata = $_SESSION['old']['iata_registered'] ?? '0'; ?>
        <select name="iata_registered" class="form-select">
          <option value="1" <?= $iata==='1'?'selected':''; ?>>Yes</option>
          <option value="0" <?= $iata!=='1'?'selected':''; ?>>No</option>
        </select>
      </div>
      <div class="col-md-3" id="grp_iata_code">
        <label class="form-label">IATA Code</label>
        <input type="text" name="iata_code" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['iata_code'] ?? '') ?>" placeholder="Required if IATA Registered is Yes">
      </div>
      <div class="col-md-3" id="grp_gst_number" style="<?= $K_GST_NUM_EN ? '' : 'display:none;' ?>">
        <label class="form-label">GST Number</label>
        <input type="text" name="gst_number" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['gst_number'] ?? '') ?>">
      </div>
      <div class="col-md-3" id="grp_gst_company" style="<?= $K_GST_COM_EN ? '' : 'display:none;' ?>">
        <label class="form-label">GST Company</label>
        <input type="text" name="gst_company" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['gst_company'] ?? '') ?>">
      </div>
      <div class="col-12"><hr class="my-2"></div>
      <div class="col-12"><span class="section-title">Business Documents</span></div>
      <div class="col-md-3" id="grp_profile_photo" style="<?= $K_PROFILE_EN ? '' : 'display:none;' ?>">
        <label class="form-label">Profile Photo (<?= $K_PROFILE_REQ ? 'required' : 'optional' ?>) <i class="bi bi-info-circle small info" data-bs-toggle="tooltip" title="Clear headshot recommended. JPG/PNG accepted."></i></label>
        <div class="input-group">
          <input type="file" name="profile_photo" class="form-control file-with-preview" accept="image/*">
          <button class="btn btn-outline-secondary btn-sm capture-btn" type="button" data-target="profile_photo">Take Photo</button>
        </div>
        <img class="thumb d-none" data-preview-for="profile_photo" alt="preview" />
        <div class="preview-meta" data-preview-meta-for="profile_photo"></div>
      </div>
      <div class="col-md-3" id="grp_business_card" style="<?= $K_BIZ_EN ? '' : 'display:none;' ?>">
        <label class="form-label">Business Card (<?= $K_BIZ_REQ ? 'required' : 'optional' ?>) <i class="bi bi-info-circle small info" data-bs-toggle="tooltip" title="Capture or upload a clear photo of your business card."></i></label>
        <div class="input-group">
          <input type="file" name="business_card" class="form-control file-with-preview" accept="image/*">
          <button class="btn btn-outline-secondary btn-sm capture-btn" type="button" data-target="business_card">Take Photo</button>
        </div>
        <img class="thumb d-none" data-preview-for="business_card" alt="preview" />
        <div class="preview-meta" data-preview-meta-for="business_card"></div>
      </div>
      <?php if ($K_SELFIE_EN): ?>
      <div class="col-md-3" id="grp_selfie">
        <label class="form-label">Selfie (<?= $K_SELFIE_REQ ? 'required' : 'optional' ?>)</label>
        <div class="input-group">
          <input type="file" name="doc_selfie" class="form-control file-with-preview" accept="image/*" <?= $K_SELFIE_REQ ? 'required' : '' ?>>
          <button class="btn btn-outline-secondary btn-sm capture-btn" type="button" data-target="doc_selfie">Take Photo</button>
        </div>
        <img class="thumb d-none" data-preview-for="doc_selfie" alt="preview" />
        <div class="preview-meta" data-preview-meta-for="doc_selfie"></div>
      </div>
      <?php endif; ?>
      <div class="col-md-3" id="grp_reg_certificate" style="<?= $K_REG_SP_EN ? '' : 'display:none;' ?>">
        <label class="form-label">Registration Certificate (Sole Proprietor)</label>
        <div class="input-group">
          <input type="file" name="doc_registration_certificate" class="form-control file-with-preview" accept="image/*,application/pdf" <?= $K_REG_SP_REQ ? 'data-req="1"' : 'data-req="0"' ?>>
          <button class="btn btn-outline-secondary btn-sm capture-btn" type="button" data-target="doc_registration_certificate">Take Photo</button>
        </div>
        <img class="thumb d-none" data-preview-for="doc_registration_certificate" alt="preview" />
        <div class="preview-meta" data-preview-meta-for="doc_registration_certificate"></div>
      </div>
      <div class="col-md-3" id="grp_partnership_deed" style="<?= $K_PART_LLP_EN ? '' : 'display:none;' ?>">
        <label class="form-label">Partnership Deed (Partnership/LLP)</label>
        <div class="input-group">
          <input type="file" name="doc_partnership_deed" class="form-control file-with-preview" accept="image/*,application/pdf" <?= $K_PART_LLP_REQ ? 'data-req="1"' : 'data-req="0"' ?>>
          <button class="btn btn-outline-secondary btn-sm capture-btn" type="button" data-target="doc_partnership_deed">Take Photo</button>
        </div>
        <img class="thumb d-none" data-preview-for="doc_partnership_deed" alt="preview" />
        <div class="preview-meta" data-preview-meta-for="doc_partnership_deed"></div>
      </div>
      <div class="col-md-3" id="grp_incorp_cert" style="<?= $K_INC_CO_EN ? '' : 'display:none;' ?>">
        <label class="form-label">Incorporation Certificate (Company)</label>
        <div class="input-group">
          <input type="file" name="doc_incorporation_certificate" class="form-control file-with-preview" accept="image/*,application/pdf" <?= $K_INC_CO_REQ ? 'data-req="1"' : 'data-req="0"' ?>>
          <button class="btn btn-outline-secondary btn-sm capture-btn" type="button" data-target="doc_incorporation_certificate">Take Photo</button>
        </div>
        <img class="thumb d-none" data-preview-for="doc_incorporation_certificate" alt="preview" />
        <div class="preview-meta" data-preview-meta-for="doc_incorporation_certificate"></div>
      </div>
      <div class="col-md-3" id="grp_address_proof" style="<?= $K_ADDR_FR_EN ? '' : 'display:none;' ?>">
        <label class="form-label">Address Proof (Freelancer/All)</label>
        <div class="input-group">
          <input type="file" name="doc_address_proof" class="form-control file-with-preview" accept="image/*,application/pdf" <?= $K_ADDR_FR_REQ ? 'data-req="1"' : 'data-req="0"' ?>>
          <button class="btn btn-outline-secondary btn-sm capture-btn" type="button" data-target="doc_address_proof">Take Photo</button>
        </div>
        <img class="thumb d-none" data-preview-for="doc_address_proof" alt="preview" />
        <div class="preview-meta" data-preview-meta-for="doc_address_proof"></div>
      </div>
      <div class="col-md-2" id="grp_commission" style="<?= $K_COMM_EN ? '' : 'display:none;' ?>">
        <label class="form-label">Commission %</label>
        <input type="number" step="0.01" min="0" max="30" name="agent_commission" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['agent_commission'] ?? (string)$K_COMM_DEF) ?>">
      </div>
      <div class="col-md-2" id="grp_credit" style="<?= $K_CREDIT_EN ? '' : 'display:none;' ?>">
        <label class="form-label">Credit Limit</label>
        <input type="number" step="0.01" min="0" name="agent_credit_limit" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['agent_credit_limit'] ?? (string)$K_CREDIT_DEF) ?>">
      </div>
      <div class="col-12"><hr class="my-2"></div>
      <div class="col-12"><span class="section-title">KYC Government ID</span></div>
      <div id="grp_govid_section" class="row g-2" style="<?= $K_GID_EN ? '' : 'display:none;' ?>">
      <div class="col-md-3">
        <label class="form-label">KYC ID Type</label>
        <select name="kyc_id_type" class="form-select" <?= $K_GID_REQ_TYPE ? 'required' : '' ?>>
          <?php $sel = $_SESSION['old']['kyc_id_type'] ?? ''; ?>
          <option value="passport" <?= $sel==='passport'?'selected':''; ?>>Passport</option>
          <option value="national_id" <?= $sel==='national_id'?'selected':''; ?>>National ID</option>
          <option value="driving_license" <?= $sel==='driving_license'?'selected':''; ?>>Driving License</option>
          <option value="other" <?= $sel==='other'?'selected':''; ?>>Other</option>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">KYC ID Number</label>
        <input type="text" name="kyc_id_number" class="form-control" value="<?= htmlspecialchars($_SESSION['old']['kyc_id_number'] ?? '') ?>" <?= $K_GID_REQ_NUMBER ? 'required' : '' ?>>
      </div>
      <div class="col-md-3">
        <label class="form-label">Govt Document (Front)</label>
        <div class="input-group">
          <input type="file" name="kyc_doc_front" class="form-control file-with-preview" accept="image/*,application/pdf" <?= $K_GID_REQ_FRONT ? 'required' : '' ?>>
          <button class="btn btn-outline-secondary btn-sm capture-btn" type="button" data-target="kyc_doc_front">Take Photo</button>
        </div>
        <img class="thumb d-none" data-preview-for="kyc_doc_front" alt="preview" />
        <div class="preview-meta" data-preview-meta-for="kyc_doc_front"></div>
      </div>
      <div class="col-md-3" id="grp_govid_back" style="<?= $K_GID_BACK_EN ? '' : 'display:none;' ?>">
        <label class="form-label">Govt Document (Back) <?= $K_GID_REQ_BACK ? '(required)' : '(optional)' ?></label>
        <div class="input-group">
          <input type="file" name="kyc_doc_back" class="form-control file-with-preview" accept="image/*,application/pdf" <?= $K_GID_REQ_BACK ? 'required' : '' ?>>
          <button class="btn btn-outline-secondary btn-sm capture-btn" type="button" data-target="kyc_doc_back">Take Photo</button>
        </div>
        <img class="thumb d-none" data-preview-for="kyc_doc_back" alt="preview" />
        <div class="preview-meta" data-preview-meta-for="kyc_doc_back"></div>
      </div>
      </div>
      </div>
    </div>
    <div class="action-bar mt-3 d-flex gap-2 justify-content-between align-items-center">
      <div class="text-muted small">Review details before creating the agent.</div>
      <div class="d-flex gap-2">
        <a class="btn btn-outline-secondary" href="/users"><i class="bi bi-people me-1"></i>Users List</a>
        <button class="btn btn-primary" type="submit"><i class="bi bi-person-plus me-1"></i>Create Agent</button>
      </div>
    </div>
  </form>
  <div class="small text-muted mt-2">Default status set to Active. Role will be saved as B2B Agent.</div>
  <?php unset($_SESSION['old']); ?>
</div>

<!-- Business Type Preview Modal -->
<div class="modal fade" id="btPreviewModal" tabindex="-1" aria-labelledby="btPreviewLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="btPreviewLabel">KYC Preview</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div id="btPreviewBody" class="small"></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" id="btPreviewApplyBtn">Apply</button>
      </div>
    </div>
  </div>
  <input type="hidden" id="_pending_bt_value" value="">
  <input type="hidden" id="_current_bt_value" value="<?= htmlspecialchars($bt) ?>">
</div>

<style>
  .camera-overlay {position:fixed; inset:0; background:rgba(0,0,0,.65); display:none; align-items:center; justify-content:center; z-index:1050;}
  .camera-box {background:#fff; border-radius:8px; width:min(720px, 96vw); padding:12px; box-shadow:0 10px 30px rgba(0,0,0,.3);}
  .camera-toolbar {display:flex; gap:8px; justify-content:space-between; align-items:center; margin-bottom:8px;}
  .camera-stage {position:relative; background:#0b1220; display:flex; justify-content:center; align-items:center; border-radius:6px; overflow:hidden;}
  .camera-stage video, .camera-stage canvas {max-width:100%; width:100%;}
  .btn-circle {border-radius:999px; width:44px; height:44px; display:inline-flex; align-items:center; justify-content:center;}
  .thumb {max-height:64px; border-radius:6px; margin-top:6px; border:1px solid #e5e7eb;}
  .preview-meta {font-size:12px; color:#6c757d;}
</style>

<div class="camera-overlay" id="cameraOverlay" aria-hidden="true">
  <div class="camera-box">
    <div class="camera-toolbar">
      <div>
        <strong>Live Capture</strong>
        <small class="text-muted ms-2" id="cameraTargetLabel"></small>
      </div>
      <div>
        <button type="button" class="btn btn-outline-secondary btn-sm" id="btnSwitchCam">Switch</button>
        <button type="button" class="btn btn-outline-danger btn-sm" id="btnCloseCam">Close</button>
      </div>
    </div>
    <div class="camera-stage">
      <video id="camVideo" autoplay playsinline></video>
      <canvas id="camCanvas" style="display:none;"></canvas>
    </div>
    <div class="d-flex justify-content-between align-items-center mt-2">
      <div>
        <button type="button" class="btn btn-secondary btn-sm" id="btnRetake" disabled>Retake</button>
        <button type="button" class="btn btn-primary btn-sm" id="btnUsePhoto" disabled>Use Photo</button>
      </div>
      <div>
        <button type="button" class="btn btn-primary btn-circle" id="btnShutter" title="Capture">
          <i class="bi bi-camera"></i>
        </button>
      </div>
    </div>
  </div>
  <input type="file" id="_hiddenCaptureInput" accept="image/*" style="display:none;" capture="environment">
  <!-- Fallback: native capture on mobile if camera blocked -->
  <img id="capturePreview" class="thumb" style="display:none;" alt="preview" />
  <input type="hidden" id="captureTargetName" value="">
  <input type="hidden" id="_dtSupport" value="">
  <input type="hidden" id="_lastBlobType" value="image/jpeg">
</div>

<script>
  (function(){
    // Init Bootstrap tooltips
    try {
      var tts = document.querySelectorAll('[data-bs-toggle="tooltip"]');
      tts.forEach(function(el){ new bootstrap.Tooltip(el); });
    } catch (e) { /* bootstrap may not be present on some layouts */ }
    const radios = document.querySelectorAll('input[name="business_type"]');
    const radioInputs = Array.from(radios);
    const iataSel = document.querySelector('select[name="iata_registered"]');
    const grpIata = document.getElementById('grp_iata_code');
    const grpIataBlock = document.getElementById('grp_iata_block');
    const grpReg = document.getElementById('grp_reg_certificate');
    const grpPart = document.getElementById('grp_partnership_deed');
    const grpIncorp = document.getElementById('grp_incorp_cert');
    const grpAddrProof = document.getElementById('grp_address_proof');
    const grpProfile = document.getElementById('grp_profile_photo');
    const grpBizCard = document.getElementById('grp_business_card');
    const grpAgency = document.getElementById('grp_agency_name');
    const grpGstNumber = document.getElementById('grp_gst_number');
    const grpGstCompany = document.getElementById('grp_gst_company');
    const grpGov = document.getElementById('grp_govid_section');
    const grpGovBack = document.getElementById('grp_govid_back');

    const fIataCode = document.querySelector('input[name="iata_code"]');
    const fReg = document.querySelector('input[name="doc_registration_certificate"]');
    const fPart = document.querySelector('input[name="doc_partnership_deed"]');
    const fIncorp = document.querySelector('input[name="doc_incorporation_certificate"]');
    const fAddrProof = document.querySelector('input[name="doc_address_proof"]');
    const fSelfie = document.querySelector('input[name="doc_selfie"]');
    const fProfile = document.querySelector('input[name="profile_photo"]');
    const fBizCard = document.querySelector('input[name="business_card"]');
    const fAgency = document.querySelector('input[name="agency_name"]');
    const fGstNumber = document.querySelector('input[name="gst_number"]');
    const fGstCompany = document.querySelector('input[name="gst_company"]');
    const fIdType = document.querySelector('select[name="kyc_id_type"]');
    const fIdNumber = document.querySelector('input[name="kyc_id_number"]');
    const fIdFront = document.querySelector('input[name="kyc_doc_front"]');
    const fIdBack = document.querySelector('input[name="kyc_doc_back"]');

    function setVis(el, show){ if(!el) return; el.style.display = show ? '' : 'none'; }
    function setReq(input, req){ if(!input) return; input.required = !!req; }

    // KYC config flags injected from PHP (base values)
    const K_PROFILE_EN = <?php echo json_encode($K_PROFILE_EN); ?>;
    const K_PROFILE_REQ = <?php echo json_encode($K_PROFILE_REQ); ?>;
    const K_BIZ_EN = <?php echo json_encode($K_BIZ_EN); ?>;
    const K_BIZ_REQ = <?php echo json_encode($K_BIZ_REQ); ?>;
    const K_SELFIE_EN = <?php echo json_encode($K_SELFIE_EN); ?>;
    const K_SELFIE_REQ = <?php echo json_encode($K_SELFIE_REQ); ?>;
    const K_REG_SP_EN = <?php echo json_encode($K_REG_SP_EN); ?>;
    const K_PART_LLP_EN = <?php echo json_encode($K_PART_LLP_EN); ?>;
    const K_INC_CO_EN = <?php echo json_encode($K_INC_CO_EN); ?>;
    const K_ADDR_FR_EN = <?php echo json_encode($K_ADDR_FR_EN); ?>;
    const K_IATA_EN = <?php echo json_encode($K_IATA_EN); ?>;
    const K_IATA_REQ_YES = <?php echo json_encode($K_IATA_REQ_YES); ?>;
    const K_GST_NUM_EN = <?php echo json_encode($K_GST_NUM_EN); ?>;
    const K_GST_NUM_REQ = <?php echo json_encode($K_GST_NUM_REQ); ?>;
    const K_GST_COM_EN = <?php echo json_encode($K_GST_COM_EN); ?>;
    const K_GST_COM_REQ = <?php echo json_encode($K_GST_COM_REQ); ?>;
    const K_AGENCY_EN = <?php echo json_encode($K_AGENCY_EN); ?>;
    const K_AGENCY_REQ_NONF = <?php echo json_encode($K_AGENCY_REQ_NONF); ?>;
    // Full KYC structure for per-type overrides
    const AGENT_KYC = <?php echo json_encode($agentKyc ?? []); ?>;

    // Effective flags for IATA, updated by updateBusinessVisibility
    let CUR_IATA_EN = !!K_IATA_EN;
    let CUR_IATA_REQ_YES = !!K_IATA_REQ_YES;
    function updateIataVisibility(){
      if (!grpIata) return;
      const yes = (iataSel && iataSel.value === '1');
      const show = !!CUR_IATA_EN && yes;
      setVis(grpIata, show);
      setReq(fIataCode, !!CUR_IATA_REQ_YES && show);
    }

    function updateBusinessVisibility(){
      let val = 'freelancer';
      radios.forEach(r => { if (r.checked) val = r.value; });
      // Toggle active class for button labels
      radioInputs.forEach(inp => {
        const label = inp.closest('label');
        if (label) label.classList.toggle('active', inp.checked);
      });
      // Map business type to per_type key
      const map = { freelancer: 'freelancer', sole_proprietor: 'sp', partnership: 'llp', company: 'co' };
      const btKey = map[val] || 'freelancer';
      const perType = (AGENT_KYC && AGENT_KYC.per_type && AGENT_KYC.per_type[btKey]) ? AGENT_KYC.per_type[btKey] : {};

      // Derive effective flags from base + per-type overrides
      // Media (Profile / Business Card): support per-type overrides
      let E_PROFILE_EN = !!(AGENT_KYC?.profile_photo?.enabled ?? K_PROFILE_EN);
      let E_PROFILE_REQ = !!(AGENT_KYC?.profile_photo?.required ?? K_PROFILE_REQ);
      let E_BIZ_EN = !!(AGENT_KYC?.business_card?.enabled ?? K_BIZ_EN);
      let E_BIZ_REQ = !!(AGENT_KYC?.business_card?.required ?? K_BIZ_REQ);
      if (perType?.media?.override) {
        const pm = perType.media;
        if (pm.profile_photo) {
          if (typeof pm.profile_photo.enabled !== 'undefined') E_PROFILE_EN = !!pm.profile_photo.enabled;
          if (typeof pm.profile_photo.required !== 'undefined') E_PROFILE_REQ = !!pm.profile_photo.required;
        }
        if (pm.business_card) {
          if (typeof pm.business_card.enabled !== 'undefined') E_BIZ_EN = !!pm.business_card.enabled;
          if (typeof pm.business_card.required !== 'undefined') E_BIZ_REQ = !!pm.business_card.required;
        }
      }

      // Selfie and Address Proof may be overridden via env and controller for current type
      let E_SELFIE_EN = !!(AGENT_KYC?.selfie?.enabled ?? K_SELFIE_EN);
      let E_SELFIE_REQ = !!(AGENT_KYC?.selfie?.required ?? K_SELFIE_REQ);
      let E_ADDR_FR_EN = !!(AGENT_KYC?.address_proof_freelancer?.enabled ?? K_ADDR_FR_EN);
      let E_ADDR_FR_REQ = !!(AGENT_KYC?.address_proof_freelancer?.required ?? false);

      // Registration toggles can be overridden per-type
      let E_REG_SP_EN = !!K_REG_SP_EN;
      let E_PART_LLP_EN = !!K_PART_LLP_EN;
      let E_INC_CO_EN = !!K_INC_CO_EN;
      if (perType?.registration?.override) {
        // When per-type Registration override is ON, show only the doc block that matches the selected type
        E_REG_SP_EN = (val === 'sole_proprietor') ? true : E_REG_SP_EN;
        E_PART_LLP_EN = (val === 'partnership') ? true : E_PART_LLP_EN;
        E_INC_CO_EN = (val === 'company') ? true : E_INC_CO_EN;
      }
      let E_IATA_EN = !!(AGENT_KYC?.registration?.iata_enabled ?? K_IATA_EN);
      let E_IATA_REQ_YES = !!(AGENT_KYC?.registration?.iata_code_required_on_yes ?? K_IATA_REQ_YES);
      let E_GST_NUM_EN = !!(AGENT_KYC?.registration?.gst_number?.enabled ?? K_GST_NUM_EN);
      let E_GST_NUM_REQ = !!(AGENT_KYC?.registration?.gst_number?.required ?? K_GST_NUM_REQ);
      let E_GST_COM_EN = !!(AGENT_KYC?.registration?.gst_company?.enabled ?? K_GST_COM_EN);
      let E_GST_COM_REQ = !!(AGENT_KYC?.registration?.gst_company?.required ?? K_GST_COM_REQ);
      if (perType?.registration?.override) {
        const pr = perType.registration;
        if (typeof pr.iata_enabled !== 'undefined') E_IATA_EN = !!pr.iata_enabled;
        if (typeof pr.iata_code_required_on_yes !== 'undefined') E_IATA_REQ_YES = !!pr.iata_code_required_on_yes;
        if (pr.gst_number) {
          if (typeof pr.gst_number.enabled !== 'undefined') E_GST_NUM_EN = !!pr.gst_number.enabled;
          if (typeof pr.gst_number.required !== 'undefined') E_GST_NUM_REQ = !!pr.gst_number.required;
        }
        if (pr.gst_company) {
          if (typeof pr.gst_company.enabled !== 'undefined') E_GST_COM_EN = !!pr.gst_company.enabled;
          if (typeof pr.gst_company.required !== 'undefined') E_GST_COM_REQ = !!pr.gst_company.required;
        }
      }

      // Business Info
      const E_AGENCY_EN = !!K_AGENCY_EN;
      const E_AGENCY_REQ_NONF = !!K_AGENCY_REQ_NONF;

      // Government ID effective flags (base + per-type override)
      const baseGov = AGENT_KYC?.gov_id || {};
      let E_GID_EN = !!(baseGov.enabled ?? true);
      let E_GID_REQ_TYPE = !!(baseGov.require_type ?? false);
      let E_GID_REQ_NUMBER = !!(baseGov.require_number ?? false);
      let E_GID_REQ_FRONT = !!(baseGov.require_front ?? false);
      let E_GID_BACK_EN = !!(baseGov.back_enabled ?? false);
      let E_GID_REQ_BACK = !!(baseGov.require_back ?? false);

      if (perType?.gov_id?.override) {
        const pg = perType.gov_id;
        // When override is ON, ensure section is visible regardless of global
        E_GID_EN = true;
        if (typeof pg.require_type !== 'undefined') E_GID_REQ_TYPE = !!pg.require_type;
        if (typeof pg.require_number !== 'undefined') E_GID_REQ_NUMBER = !!pg.require_number;
        if (typeof pg.require_front !== 'undefined') E_GID_REQ_FRONT = !!pg.require_front;
        if (typeof pg.front_enabled !== 'undefined' && pg.front_enabled === false) {
          // If front explicitly disabled per-type, then front cannot be required
          E_GID_REQ_FRONT = false;
        }
        if (typeof pg.back_enabled !== 'undefined') E_GID_BACK_EN = !!pg.back_enabled;
        if (typeof pg.require_back !== 'undefined') E_GID_REQ_BACK = !!pg.require_back;
      }

      // Apply visibility
      setVis(grpProfile, E_PROFILE_EN);
      setVis(grpBizCard, E_BIZ_EN);
      // Registration (IATA/GST)
      setVis(grpIataBlock, E_IATA_EN);
      setVis(grpGstNumber, E_GST_NUM_EN);
      setVis(grpGstCompany, E_GST_COM_EN);
      setVis(grpReg, (val === 'sole_proprietor') && E_REG_SP_EN);
      setVis(grpPart, (val === 'partnership') && E_PART_LLP_EN);
      setVis(grpIncorp, (val === 'company') && E_INC_CO_EN);
      setVis(grpAddrProof, E_ADDR_FR_EN);
      setVis(grpAgency, E_AGENCY_EN && (val !== 'freelancer'));
      setVis(grpGov, E_GID_EN);
      setVis(grpGovBack, E_GID_EN && E_GID_BACK_EN);

      // Required flags
      setReq(fSelfie, E_SELFIE_EN && E_SELFIE_REQ);
      setReq(fProfile, E_PROFILE_EN && E_PROFILE_REQ);
      setReq(fBizCard, E_BIZ_EN && E_BIZ_REQ);

      // Business-type dependent docs: read data-req attr and require only when group is visible
      const reqReg = (fReg && fReg.getAttribute('data-req') === '1');
      const reqPart = (fPart && fPart.getAttribute('data-req') === '1');
      const reqInc = (fIncorp && fIncorp.getAttribute('data-req') === '1');
      const reqAddr = (fAddrProof && fAddrProof.getAttribute('data-req') === '1');
      setReq(fReg, (val === 'sole_proprietor') && E_REG_SP_EN && reqReg);
      setReq(fPart, (val === 'partnership') && E_PART_LLP_EN && reqPart);
      setReq(fIncorp, (val === 'company') && E_INC_CO_EN && reqInc);
      setReq(fAddrProof, E_ADDR_FR_EN && (val === 'freelancer') && (E_ADDR_FR_REQ && reqAddr));
      // Agency Name required for non-freelancer if enabled
      setReq(fAgency, E_AGENCY_EN && E_AGENCY_REQ_NONF && (val !== 'freelancer'));

      // Persist effective IATA flags for updateIataVisibility
      CUR_IATA_EN = E_IATA_EN;
      CUR_IATA_REQ_YES = E_IATA_REQ_YES;
      // GST required flags (visibility already controlled server-side)
      if (grpGstNumber && fGstNumber) setReq(fGstNumber, E_GST_NUM_EN && E_GST_NUM_REQ);
      if (grpGstCompany && fGstCompany) setReq(fGstCompany, E_GST_COM_EN && E_GST_COM_REQ);
      // Gov ID requirements
      setReq(fIdType, E_GID_EN && E_GID_REQ_TYPE);
      setReq(fIdNumber, E_GID_EN && E_GID_REQ_NUMBER);
      setReq(fIdFront, E_GID_EN && E_GID_REQ_FRONT);
      setReq(fIdBack, E_GID_EN && E_GID_BACK_EN && E_GID_REQ_BACK);
      // Apply IATA visibility with effective flags
      updateIataVisibility();
    }

    // Intercept click on business type to show preview modal first
    const pendingBtInput = document.getElementById('_pending_bt_value');
    const currentBtInput = document.getElementById('_current_bt_value');
    let previewModal = null;
    function bsModal(el){
      try { return new bootstrap.Modal(el); } catch(e) { return null; }
    }

    function computeEffective(val){
      const map = { freelancer: 'freelancer', sole_proprietor: 'sp', partnership: 'llp', company: 'co' };
      const btKey = map[val] || 'freelancer';
      const perType = (AGENT_KYC && AGENT_KYC.per_type && AGENT_KYC.per_type[btKey]) ? AGENT_KYC.per_type[btKey] : {};
      // Registration
      let E_REG_SP_EN = !!K_REG_SP_EN, E_PART_LLP_EN = !!K_PART_LLP_EN, E_INC_CO_EN = !!K_INC_CO_EN;
      if (perType?.registration?.override) {
        E_REG_SP_EN = (val === 'sole_proprietor') ? true : E_REG_SP_EN;
        E_PART_LLP_EN = (val === 'partnership') ? true : E_PART_LLP_EN;
        E_INC_CO_EN = (val === 'company') ? true : E_INC_CO_EN;
      }
      let E_IATA_EN = !!(AGENT_KYC?.registration?.iata_enabled ?? K_IATA_EN);
      let E_IATA_REQ_YES = !!(AGENT_KYC?.registration?.iata_code_required_on_yes ?? K_IATA_REQ_YES);
      let E_GST_NUM_EN = !!(AGENT_KYC?.registration?.gst_number?.enabled ?? K_GST_NUM_EN);
      let E_GST_NUM_REQ = !!(AGENT_KYC?.registration?.gst_number?.required ?? K_GST_NUM_REQ);
      let E_GST_COM_EN = !!(AGENT_KYC?.registration?.gst_company?.enabled ?? K_GST_COM_EN);
      let E_GST_COM_REQ = !!(AGENT_KYC?.registration?.gst_company?.required ?? K_GST_COM_REQ);
      if (perType?.registration?.override) {
        const pr = perType.registration;
        if (typeof pr.iata_enabled !== 'undefined') E_IATA_EN = !!pr.iata_enabled;
        if (typeof pr.iata_code_required_on_yes !== 'undefined') E_IATA_REQ_YES = !!pr.iata_code_required_on_yes;
        if (pr.gst_number) {
          if (typeof pr.gst_number.enabled !== 'undefined') E_GST_NUM_EN = !!pr.gst_number.enabled;
          if (typeof pr.gst_number.required !== 'undefined') E_GST_NUM_REQ = !!pr.gst_number.required;
        }
        if (pr.gst_company) {
          if (typeof pr.gst_company.enabled !== 'undefined') E_GST_COM_EN = !!pr.gst_company.enabled;
          if (typeof pr.gst_company.required !== 'undefined') E_GST_COM_REQ = !!pr.gst_company.required;
        }
      }
      // Gov ID
      const baseGov = AGENT_KYC?.gov_id || {};
      let E_GID_EN = !!(baseGov.enabled ?? true);
      let E_GID_REQ_TYPE = !!(baseGov.require_type ?? false);
      let E_GID_REQ_NUMBER = !!(baseGov.require_number ?? false);
      let E_GID_REQ_FRONT = !!(baseGov.require_front ?? false);
      let E_GID_BACK_EN = !!(baseGov.back_enabled ?? false);
      let E_GID_REQ_BACK = !!(baseGov.require_back ?? false);
      if (perType?.gov_id?.override) {
        const pg = perType.gov_id;
        E_GID_EN = true;
        if (typeof pg.require_type !== 'undefined') E_GID_REQ_TYPE = !!pg.require_type;
        if (typeof pg.require_number !== 'undefined') E_GID_REQ_NUMBER = !!pg.require_number;
        if (typeof pg.require_front !== 'undefined') E_GID_REQ_FRONT = !!pg.require_front;
        if (typeof pg.front_enabled !== 'undefined' && pg.front_enabled === false) E_GID_REQ_FRONT = false;
        if (typeof pg.back_enabled !== 'undefined') E_GID_BACK_EN = !!pg.back_enabled;
        if (typeof pg.require_back !== 'undefined') E_GID_REQ_BACK = !!pg.require_back;
      }
      // Media with per-type overrides
      let E_PROFILE_EN = !!(AGENT_KYC?.profile_photo?.enabled ?? K_PROFILE_EN), E_PROFILE_REQ = !!(AGENT_KYC?.profile_photo?.required ?? K_PROFILE_REQ);
      let E_BIZ_EN = !!(AGENT_KYC?.business_card?.enabled ?? K_BIZ_EN), E_BIZ_REQ = !!(AGENT_KYC?.business_card?.required ?? K_BIZ_REQ);
      if (perType?.media?.override) {
        const pm = perType.media;
        if (pm.profile_photo) {
          if (typeof pm.profile_photo.enabled !== 'undefined') E_PROFILE_EN = !!pm.profile_photo.enabled;
          if (typeof pm.profile_photo.required !== 'undefined') E_PROFILE_REQ = !!pm.profile_photo.required;
        }
        if (pm.business_card) {
          if (typeof pm.business_card.enabled !== 'undefined') E_BIZ_EN = !!pm.business_card.enabled;
          if (typeof pm.business_card.required !== 'undefined') E_BIZ_REQ = !!pm.business_card.required;
        }
      }
      const E_SELFIE_EN = !!(AGENT_KYC?.selfie?.enabled ?? true);
      const E_SELFIE_REQ = !!(AGENT_KYC?.selfie?.required ?? false);
      const E_ADDR_FR_EN = !!(AGENT_KYC?.address_proof_freelancer?.enabled ?? true);
      const E_ADDR_FR_REQ = !!(AGENT_KYC?.address_proof_freelancer?.required ?? false);
      const E_AGENCY_EN = !!K_AGENCY_EN, E_AGENCY_REQ_NONF = !!K_AGENCY_REQ_NONF;
      return { val, E_REG_SP_EN, E_PART_LLP_EN, E_INC_CO_EN, E_IATA_EN, E_IATA_REQ_YES, E_GST_NUM_EN, E_GST_NUM_REQ, E_GST_COM_EN, E_GST_COM_REQ, E_GID_EN, E_GID_REQ_TYPE, E_GID_REQ_NUMBER, E_GID_REQ_FRONT, E_GID_BACK_EN, E_GID_REQ_BACK, E_PROFILE_EN, E_PROFILE_REQ, E_BIZ_EN, E_BIZ_REQ, E_SELFIE_EN, E_SELFIE_REQ, E_ADDR_FR_EN, E_ADDR_FR_REQ, E_AGENCY_EN, E_AGENCY_REQ_NONF };
    }

    function renderPreview(eff){
      function yn(b){return b?'<span class="badge bg-success">Yes</span>':'<span class="badge bg-secondary">No</span>'}
      const btName = {freelancer:'Freelancer', sole_proprietor:'Sole Proprietor', partnership:'Partnership/LLP', company:'Company'}[eff.val] || eff.val;
      return `
        <div class="mb-2"><strong>Business Type:</strong> ${btName}</div>
        <div class="row g-3">
          <div class="col-md-6">
            <div class="fw-semibold mb-1">Government ID</div>
            <div>Section: ${yn(eff.E_GID_EN)}</div>
            <div>ID Type required: ${yn(eff.E_GID_REQ_TYPE)}</div>
            <div>ID Number required: ${yn(eff.E_GID_REQ_NUMBER)}</div>
            <div>Front required: ${yn(eff.E_GID_REQ_FRONT)}</div>
            <div>Back enabled: ${yn(eff.E_GID_BACK_EN)} | Back required: ${yn(eff.E_GID_REQ_BACK)}</div>
          </div>
          <div class="col-md-6">
            <div class="fw-semibold mb-1">Registration</div>
            <div>IATA: ${yn(eff.E_IATA_EN)} | Code on Yes: ${yn(eff.E_IATA_REQ_YES)}</div>
            <div>GST Number: ${yn(eff.E_GST_NUM_EN)} | Required: ${yn(eff.E_GST_NUM_REQ)}</div>
            <div>GST Company: ${yn(eff.E_GST_COM_EN)} | Required: ${yn(eff.E_GST_COM_REQ)}</div>
            <div class="mt-1">Doc blocks visible: 
              ${eff.val==='sole_proprietor' && eff.E_REG_SP_EN ? 'Reg Certificate (SP)' : ''}
              ${eff.val==='partnership' && eff.E_PART_LLP_EN ? (eff.E_REG_SP_EN?' , ':'') + 'Partnership Deed' : ''}
              ${eff.val==='company' && eff.E_INC_CO_EN ? ((eff.E_REG_SP_EN||eff.E_PART_LLP_EN)?' , ':'') + 'Incorp Cert' : ''}
            </div>
          </div>
        </div>
        <hr/>
        <div class="row g-3">
          <div class="col-md-6">
            <div class="fw-semibold mb-1">Media</div>
            <div>Profile Photo: ${yn(eff.E_PROFILE_EN)} | Required: ${yn(eff.E_PROFILE_REQ)}</div>
            <div>Business Card: ${yn(eff.E_BIZ_EN)} | Required: ${yn(eff.E_BIZ_REQ)}</div>
            <div>Selfie: ${yn(eff.E_SELFIE_EN)} | Required: ${yn(eff.E_SELFIE_REQ)}</div>
          </div>
          <div class="col-md-6">
            <div class="fw-semibold mb-1">Other</div>
            <div>Address Proof: ${yn(eff.E_ADDR_FR_EN)} | Required: ${yn(eff.E_ADDR_FR_REQ)}</div>
            <div>Agency Name for non-freelancer: ${yn(eff.E_AGENCY_EN && eff.E_AGENCY_REQ_NONF)}</div>
          </div>
        </div>`;
    }

    function openBtPreview(val){
      pendingBtInput.value = val;
      const eff = computeEffective(val);
      const body = document.getElementById('btPreviewBody');
      body.innerHTML = renderPreview(eff);
      const label = document.getElementById('btPreviewLabel');
      label.textContent = 'KYC Preview — ' + ({freelancer:'Freelancer', sole_proprietor:'Sole Proprietor', partnership:'Partnership/LLP', company:'Company'}[val] || val);
      const modalEl = document.getElementById('btPreviewModal');
      previewModal = previewModal || bsModal(modalEl);
      if (previewModal && previewModal.show) previewModal.show(); else modalEl.style.display = 'block';
    }

    radios.forEach(r => r.addEventListener('click', function(ev){ ev.preventDefault(); openBtPreview(this.value); }));
    document.getElementById('btPreviewApplyBtn').addEventListener('click', function(){
      const val = pendingBtInput.value || 'freelancer';
      // set radio and dispatch change
      let target = null;
      radios.forEach(r => { if (r.value === val) { r.checked = true; target = r; } else { r.checked = false; } });
      currentBtInput.value = val;
      if (previewModal && previewModal.hide) previewModal.hide(); else document.getElementById('btPreviewModal').style.display = 'none';
      if (target) {
        const evt = new Event('change', { bubbles: true });
        target.dispatchEvent(evt);
      } else {
        updateBusinessVisibility();
      }
    });

    radios.forEach(r => r.addEventListener('change', updateBusinessVisibility));
    if (iataSel) iataSel.addEventListener('change', updateIataVisibility);

    // Init on load
    updateBusinessVisibility();
    updateIataVisibility();
  })();
</script>

<script>
  // Address dropdowns using local JSON (ISO countries + subdivisions)
  (function(){
    const countrySel = document.getElementById('countrySelect');
    const stateSel = document.getElementById('stateSelect');
    const stateText = document.getElementById('stateText');
    const oldCountry = <?php echo json_encode($_SESSION['old']['country'] ?? ''); ?>;
    const oldState = <?php echo json_encode($_SESSION['old']['state'] ?? ''); ?>;

    let countries = [];
    let subdivisions = {};

    function fillCountries(){
      if (!countrySel) return;
      countrySel.innerHTML = '<option value="">Select country</option>';
      countries.forEach(c => {
        const opt = document.createElement('option');
        opt.value = c.name; // store readable name in form value
        opt.dataset.code = c.code; // keep ISO code for state lookup
        opt.textContent = c.name;
        if (oldCountry && oldCountry === c.name) opt.selected = true;
        countrySel.appendChild(opt);
      });
    }

    function getSelectedCountryCode(){
      const sel = countrySel;
      if (!sel) return '';
      const idx = sel.selectedIndex;
      if (idx < 0) return '';
      const opt = sel.options[idx];
      return opt?.dataset?.code || '';
    }

    function useSelectStateMode(enable){
      if (!stateSel || !stateText) return;
      if (enable) {
        stateSel.classList.remove('d-none');
        stateSel.disabled = false;
        stateSel.required = true;
        stateText.classList.add('d-none');
        stateText.disabled = true;
        stateText.required = false;
      } else {
        stateSel.classList.add('d-none');
        stateSel.disabled = true;
        stateSel.required = false;
        stateText.classList.remove('d-none');
        stateText.disabled = false;
        stateText.required = true;
      }
    }

    function fillStates(){
      if (!stateSel) return;
      stateSel.innerHTML = '<option value="">Select state</option>';
      const code = getSelectedCountryCode();
      const list = subdivisions[code] || [];
      list.forEach(s => {
        const opt = document.createElement('option');
        opt.value = s.name; // readable name in form value
        opt.dataset.code = s.code;
        opt.textContent = s.name;
        if (oldState && oldState === s.name) opt.selected = true;
        stateSel.appendChild(opt);
      });
      if (list.length === 0) {
        // No predefined states: switch to manual text input
        if (stateText && !oldState) stateText.value = '';
        useSelectStateMode(false);
      } else {
        useSelectStateMode(true);
      }
    }

    function onCountryChange(){
      // clear prior state selection and refill
      if (stateSel) stateSel.value = '';
      if (stateText) stateText.value = '';
      fillStates();
    }

    Promise.all([
      fetch('/assets/js/geo-countries.json').then(r => r.json()).then(d => { countries = d || []; }),
      fetch('/assets/js/geo-subdivisions.json').then(r => r.json()).then(d => { subdivisions = d || {}; })
    ]).then(() => {
      fillCountries();
      fillStates();
    }).catch(() => {
      // fail quietly; dropdowns remain minimal
    });

    countrySel?.addEventListener('change', onCountryChange);
  })();
</script>

<script>
  (function(){
    const overlay = document.getElementById('cameraOverlay');
    const video = document.getElementById('camVideo');
    const canvas = document.getElementById('camCanvas');
    const btnClose = document.getElementById('btnCloseCam');
    const btnSwitch = document.getElementById('btnSwitchCam');
    const btnShutter = document.getElementById('btnShutter');
    const btnUse = document.getElementById('btnUsePhoto');
    const btnRetake = document.getElementById('btnRetake');
    const targetLabel = document.getElementById('cameraTargetLabel');
    const captureTargetName = document.getElementById('captureTargetName');

    const hiddenCapture = document.getElementById('_hiddenCaptureInput');
    const captureBtns = document.querySelectorAll('.capture-btn');

    // Admin setting: allow manual file selection?
    const ALLOW_MANUAL = <?php echo !empty($allowManualUploads) ? 'true' : 'false'; ?>;
    (function enforceManualSetting(){
      try {
        // light visual cue
        const st = document.createElement('style');
        st.textContent = '.manual-disabled{opacity:.6; cursor:not-allowed;}';
        document.head.appendChild(st);
      } catch(e) {}
      if (!ALLOW_MANUAL) {
        document.querySelectorAll('input[type="file"].file-with-preview').forEach(inp => {
          inp.classList.add('manual-disabled');
          inp.setAttribute('aria-disabled','true');
          // prevent mouse/touch open
          inp.addEventListener('click', (ev) => {
            ev.preventDefault(); ev.stopPropagation();
            alert('Manual upload is disabled by admin. Please use Take Photo.');
          });
          // prevent keyboard open
          inp.addEventListener('keydown', (ev) => { ev.preventDefault(); ev.stopPropagation(); });
        });
      }
    })();

    let currentStream = null;
    let facing = 'environment'; // try back camera first where available
    let capturedBlob = null;
    let lastStampText = '';

    function fmt(ts){
      const d = new Date(ts);
      const pad = n => (n<10?'0':'')+n;
      const yyyy = d.getFullYear();
      const mm = pad(d.getMonth()+1);
      const dd = pad(d.getDate());
      const hh = pad(d.getHours());
      const mi = pad(d.getMinutes());
      return `${yyyy}-${mm}-${dd} ${hh}:${mi}`;
    }

    function setMeta(name, text){
      const el = document.querySelector('[data-preview-meta-for="'+name+'"]');
      if (el){ el.textContent = text ? `Captured: ${text}` : ''; }
    }

    function stopStream(){
      if (currentStream) {
        currentStream.getTracks().forEach(t => t.stop());
        currentStream = null;
      }
    }

    async function startStream(){
      try {
        stopStream();
        const constraints = { video: { facingMode: { ideal: facing }, width: { ideal: 1280 }, height: { ideal: 720 } }, audio: false };
        currentStream = await navigator.mediaDevices.getUserMedia(constraints);
        video.srcObject = currentStream;
        await video.play();
      } catch (e) {
        // If permission blocked or not supported, use native file capture as fallback (mobile)
        hiddenCapture.onchange = () => {
          const f = hiddenCapture.files && hiddenCapture.files[0];
          if (!f) return;
          useBlob(f, f.type || 'image/jpeg');
        };
        hiddenCapture.click();
      }
    }

    function openCam(targetName){
      captureTargetName.value = targetName;
      targetLabel.textContent = '[' + targetName + ']';
      overlay.style.display = 'flex';
      capturedBlob = null;
      btnUse.disabled = true;
      btnRetake.disabled = true;
      startStream();
    }

    function drawToCanvas(){
      const w = video.videoWidth || 1280;
      const h = video.videoHeight || 720;
      canvas.width = w; canvas.height = h;
      const ctx = canvas.getContext('2d');
      ctx.drawImage(video, 0, 0, w, h);
      // Watermark with date-time at bottom
      lastStampText = fmt(Date.now());
      const padX = 14, padY = 10;
      ctx.font = '20px system-ui, -apple-system, Segoe UI, Roboto, Arial';
      ctx.textBaseline = 'bottom';
      const textW = ctx.measureText(lastStampText).width;
      const boxW = textW + padX*2;
      const boxH = 28 + padY*2;
      const x = w - boxW - 12;
      const y = h - 12;
      ctx.fillStyle = 'rgba(0,0,0,0.55)';
      ctx.fillRect(x, y - boxH, boxW, boxH);
      ctx.fillStyle = '#ffffff';
      ctx.fillText(lastStampText, x + padX, y - padY);
      return new Promise(resolve => {
        canvas.toBlob(b => resolve(b), 'image/jpeg', 0.92);
      });
    }

    function useBlob(blob, type){
      capturedBlob = blob;
      btnUse.disabled = false;
      btnRetake.disabled = false;
      // Show snapshot preview inside overlay
      if (blob) {
        canvas.style.display = 'block';
        video.style.display = 'none';
        // ensure canvas already has the frame drawn when called from shutter
      }
    }

    function closeCam(){
      stopStream();
      overlay.style.display = 'none';
      capturedBlob = null;
    }

    btnShutter.addEventListener('click', async () => {
      if (!video.srcObject) return;
      const blob = await drawToCanvas();
      useBlob(blob, 'image/jpeg');
    });

    btnRetake.addEventListener('click', () => {
      capturedBlob = null;
      btnUse.disabled = true;
      btnRetake.disabled = true;
      // Return to live view
      canvas.style.display = 'none';
      video.style.display = 'block';
    });

    function updateThumb(name, file){
      const img = document.querySelector('img[data-preview-for="'+name+'"]');
      if (!img) return;
      if (file && file.type && file.type.startsWith('image/')){
        const url = URL.createObjectURL(file);
        img.src = url;
        img.classList.remove('d-none');
        // set default meta if not already set by capture
        if (!lastStampText) setMeta(name, fmt(Date.now()));
      } else {
        img.classList.add('d-none');
        setMeta(name, '');
      }
    }

    btnUse.addEventListener('click', async () => {
      if (!capturedBlob) return;
      const file = new File([capturedBlob], 'capture_'+Date.now()+'.jpg', { type: 'image/jpeg' });
      const input = document.querySelector('input[name="'+ captureTargetName.value +'"]');
      if (!input) return closeCam();
      // Assign to file input
      try {
        const dt = new DataTransfer();
        dt.items.add(file);
        input.files = dt.files;
        updateThumb(captureTargetName.value, file);
        setMeta(captureTargetName.value, lastStampText || fmt(Date.now()));
      } catch (e) {
        // Fallback: show message
        alert('Captured, but your browser prevented setting the file. Please use the Upload button instead.');
      }
      closeCam();
    });

    btnClose.addEventListener('click', closeCam);
    btnSwitch.addEventListener('click', () => {
      facing = (facing === 'environment') ? 'user' : 'environment';
      startStream();
    });

    captureBtns.forEach(btn => {
      btn.addEventListener('click', () => {
        const target = btn.getAttribute('data-target');
        openCam(target);
        // reset overlay to live view
        canvas.style.display = 'none';
        video.style.display = 'block';
      });
    });

    window.addEventListener('keydown', (e)=>{
      if (e.key === 'Escape' && overlay.style.display==='flex') closeCam();
    });
  })();
</script>
