<?php /** @var array $settings */ ?>
<?php
  $adminTop = __DIR__ . '/../partials/admin_top_nav.php';
  if (file_exists($adminTop)) include $adminTop;
?>
<div class="container py-4">
  <div class="d-flex align-items-center mb-3">
    <h4 class="m-0">Email Settings</h4>
  </div>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger">
      <?php foreach ((array)$_SESSION['errors'] as $e): ?><div>- <?= htmlspecialchars($e) ?></div><?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <div class="card shadow-sm">
    <div class="card-body">
      <form method="post" action="/admin/settings/email/save">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">

        <div class="row g-3">
          <div class="col-md-4">
            <label class="form-label fw-semibold">Active Provider</label>
            <select name="active_provider" class="form-select">
              <?php $ap = $settings['active_provider'] ?? 'smtp'; ?>
              <option value="ses" <?= $ap==='ses'?'selected':'' ?>>Amazon SES (SMTP)</option>
              <option value="sendgrid" <?= $ap==='sendgrid'?'selected':'' ?>>SendGrid (API)</option>
              <option value="smtp" <?= $ap==='smtp'?'selected':'' ?>>Generic SMTP</option>
            </select>
          </div>
          <div class="col-md-4">
            <label class="form-label fw-semibold">From Name</label>
            <input type="text" class="form-control" name="from_name" value="<?= htmlspecialchars($settings['from_name'] ?? 'B2B Travel') ?>">
          </div>
          <div class="col-md-4">
            <label class="form-label fw-semibold">From Email</label>
            <input type="email" class="form-control" name="from_email" value="<?= htmlspecialchars($settings['from_email'] ?? 'noreply@example.com') ?>">
          </div>
          <div class="col-md-4">
            <label class="form-label">Reply-To Email</label>
            <input type="email" class="form-control" name="reply_to_email" value="<?= htmlspecialchars($settings['reply_to_email'] ?? '') ?>">
          </div>
          <div class="col-md-8">
            <label class="form-label">BCC (comma-separated)</label>
            <input type="text" class="form-control" name="bcc_list" value="<?= htmlspecialchars($settings['bcc_list'] ?? '') ?>">
          </div>
        </div>

        <hr>
        <h6 class="text-uppercase text-muted">Amazon SES (SMTP)</h6>
        <div class="row g-3">
          <div class="col-md-4">
            <label class="form-label">SES Region</label>
            <input type="text" class="form-control" name="ses_region" value="<?= htmlspecialchars($settings['ses_region'] ?? '') ?>" placeholder="e.g., ap-southeast-1">
          </div>
          <div class="col-md-4">
            <label class="form-label">SES SMTP Username</label>
            <input type="text" class="form-control" name="ses_smtp_username" value="<?= htmlspecialchars($settings['ses_smtp_username'] ?? '') ?>">
          </div>
          <div class="col-md-4">
            <label class="form-label">SES SMTP Password</label>
            <input type="password" class="form-control" name="ses_smtp_password" value="<?= htmlspecialchars($settings['ses_smtp_password'] ?? '') ?>">
          </div>
        </div>

        <hr>
        <h6 class="text-uppercase text-muted">SendGrid</h6>
        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label">SendGrid API Key</label>
            <input type="password" class="form-control" name="sendgrid_api_key" value="<?= htmlspecialchars($settings['sendgrid_api_key'] ?? '') ?>">
          </div>
        </div>

        <hr>
        <h6 class="text-uppercase text-muted">Generic SMTP</h6>
        <div class="row g-3">
          <div class="col-md-4">
            <label class="form-label">Host</label>
            <input type="text" class="form-control" name="smtp_host" value="<?= htmlspecialchars($settings['smtp_host'] ?? '') ?>">
          </div>
          <div class="col-md-2">
            <label class="form-label">Port</label>
            <input type="number" class="form-control" name="smtp_port" value="<?= htmlspecialchars((string)($settings['smtp_port'] ?? '587')) ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Username</label>
            <input type="text" class="form-control" name="smtp_username" value="<?= htmlspecialchars($settings['smtp_username'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Password</label>
            <input type="password" class="form-control" name="smtp_password" value="<?= htmlspecialchars($settings['smtp_password'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Encryption</label>
            <select class="form-select" name="smtp_encryption">
              <?php $enc = $settings['smtp_encryption'] ?? 'tls'; ?>
              <option value="none" <?= $enc==='none'?'selected':'' ?>>None</option>
              <option value="ssl" <?= $enc==='ssl'?'selected':'' ?>>SSL</option>
              <option value="tls" <?= $enc==='tls'?'selected':'' ?>>TLS</option>
            </select>
          </div>
        </div>

        <hr>
        <h6 class="text-uppercase text-muted">Per-Notification Toggles</h6>
        <div class="row g-3">
          <?php function cb($key,$label,$settings){ $val = (int)($settings[$key] ?? 0); ?>
            <div class="col-md-3"><div class="form-check form-switch">
              <input class="form-check-input" type="checkbox" name="<?= $key ?>" id="<?= $key ?>" <?= $val? 'checked':'' ?>>
              <label class="form-check-label" for="<?= $key ?>"><?= $label ?></label>
            </div></div>
          <?php } ?>
          <?php cb('enable_taxi_vendor','Taxi → Vendor',$settings); cb('enable_taxi_agent','Taxi → Agent',$settings); cb('enable_taxi_internal','Taxi → Internal',$settings); ?>
          <?php cb('enable_hotel_vendor','Hotel → Vendor',$settings); cb('enable_hotel_agent','Hotel → Agent',$settings); cb('enable_hotel_internal','Hotel → Internal',$settings); ?>
          <?php cb('enable_activity_vendor','Activity → Vendor',$settings); cb('enable_activity_agent','Activity → Agent',$settings); cb('enable_activity_internal','Activity → Internal',$settings); ?>
        </div>

        <div class="mt-4 d-flex align-items-center gap-2">
          <div class="ms-auto"></div>
          <div>
            <label class="form-label">Master Password</label>
            <input type="password" class="form-control" name="master_password" required>
          </div>
          <button type="submit" class="btn btn-primary">Save Settings</button>
        </div>
      </form>

      <hr class="my-4">
      <form method="post" action="/admin/settings/email/test" class="d-flex align-items-end gap-2">
        <div>
          <label class="form-label">Test recipient</label>
          <input type="email" name="to" class="form-control" placeholder="you@example.com" required>
        </div>
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
        <button type="submit" class="btn btn-outline-primary">Send Test via Active Provider</button>
      </form>

      <hr class="my-4">
      <form method="post" action="/admin/mail/queue/process" class="row g-3 align-items-end">
        <div class="col-auto">
          <label class="form-label">Process Queue (batch size)</label>
          <input type="number" name="limit" class="form-control" value="20" min="1" max="100">
        </div>
        <div class="col-auto">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
          <button type="submit" class="btn btn-success">Process Now</button>
          <a href="/admin/logs/emails" class="btn btn-outline-secondary">View Logs</a>
        </div>
      </form>
    </div>
  </div>
</div>
<?php
  $adminFooter = __DIR__ . '/../partials/footer_admin.php';
  if (file_exists($adminFooter)) include $adminFooter;
?>
