<?php /** @var array $logs */ ?>
<?php include __DIR__ . '/../partials/header_admin.php'; ?>
<div class="container py-4">
  <div class="d-flex align-items-center mb-3">
    <h4 class="m-0">Email Logs</h4>
    <a href="/admin/settings/email" class="btn btn-link ms-auto">Settings</a>
  </div>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger">
      <?php foreach ((array)$_SESSION['errors'] as $e): ?><div>- <?= htmlspecialchars($e) ?></div><?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <div class="card shadow-sm">
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead class="table-light">
            <tr>
              <th>ID</th>
              <th>Time</th>
              <th>Provider</th>
              <th>Status</th>
              <th>Module</th>
              <th>Audience</th>
              <th>Booking</th>
              <th>To</th>
              <th>Subject</th>
              <th class="text-end">Actions</th>
            </tr>
          </thead>
          <tbody>
          <?php foreach ($logs as $r): ?>
            <tr>
              <td><?= (int)$r['id'] ?></td>
              <td><?= htmlspecialchars((string)$r['created_at']) ?></td>
              <td><span class="badge bg-secondary text-uppercase"><?= htmlspecialchars((string)$r['provider']) ?></span></td>
              <td>
                <?php if ((string)$r['status']==='sent'): ?>
                  <span class="badge bg-success">Sent</span>
                <?php else: ?>
                  <span class="badge bg-danger">Failed</span>
                <?php endif; ?>
              </td>
              <td><?= htmlspecialchars((string)$r['module']) ?></td>
              <td><?= htmlspecialchars((string)$r['audience']) ?></td>
              <td><?= (int)$r['booking_id'] ?: '-' ?></td>
              <td>
                <?php
                  $email = strtolower(trim((string)$r['to_email']));
                  $suppressed = false;
                  try {
                    $st = $this->pdo->prepare('SELECT type FROM mail_suppressions WHERE email=:e LIMIT 1');
                    $st->execute([':e'=>$email]);
                    $suppressed = (bool)$st->fetchColumn();
                  } catch (\Throwable $_) { $suppressed = false; }
                ?>
                <?= htmlspecialchars((string)$r['to_email']) ?>
                <?php if ($suppressed): ?><span class="badge bg-warning text-dark">Suppressed</span><?php endif; ?>
              </td>
              <td class="text-truncate" style="max-width:240px" title="<?= htmlspecialchars((string)$r['subject']) ?>"><?= htmlspecialchars((string)$r['subject']) ?></td>
              <td class="text-end">
                <?php if ((string)$r['status'] === 'failed'): ?>
                  <form method="post" action="/admin/logs/emails/resend" class="d-inline">
                    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                    <input type="hidden" name="log_id" value="<?= (int)$r['id'] ?>">
                    <input type="password" name="master_password" class="form-control form-control-sm d-inline-block" style="width:140px" placeholder="Master Password" required>
                    <button type="submit" class="btn btn-sm btn-outline-primary">Resend</button>
                  </form>
                <?php endif; ?>
              </td>
            </tr>
            <?php if (!empty($r['error_text'])): ?>
            <tr>
              <td></td>
              <td colspan="9" class="small text-danger">Error: <?= htmlspecialchars((string)$r['error_text']) ?></td>
            </tr>
            <?php endif; ?>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../partials/footer_admin.php'; ?>
