<?php
// app/Views/admin/kyc_index.php
use App\Core\Security;
?>
<div class="container py-2">
  <div class="d-flex align-items-center justify-content-between mb-2">
    <h2 class="h6 mb-0"><i class="bi bi-shield-check me-2"></i>KYC Reviews</h2>
  </div>
  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-info py-2 mb-3"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>
  <div class="table-responsive">
    <table class="table table-sm table-hover align-middle">
      <thead>
        <tr>
          <th>ID</th>
          <th>User</th>
          <th>Email</th>
          <th>Country</th>
          <th>ID Type</th>
          <th>ID Number</th>
          <th>Status</th>
          <th>Submitted</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach (($kycs ?? []) as $k): ?>
          <tr>
            <td><?= (int)$k['id'] ?></td>
            <td><?= Security::sanitize($k['name']) ?></td>
            <td><?= Security::sanitize($k['email']) ?></td>
            <td><?= Security::sanitize($k['country'] ?? '') ?></td>
            <td><span class="badge bg-secondary"><?= Security::sanitize($k['id_type']) ?></span></td>
            <td><?= Security::sanitize($k['id_number']) ?></td>
            <td>
              <?php if ($k['status']==='pending'): ?>
                <span class="badge bg-warning text-dark">pending</span>
              <?php elseif ($k['status']==='approved'): ?>
                <span class="badge bg-success">approved</span>
              <?php else: ?>
                <span class="badge bg-danger">rejected</span>
              <?php endif; ?>
            </td>
            <td><?= Security::sanitize($k['created_at']) ?></td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-primary" href="/admin/kyc/view?id=<?= (int)$k['id'] ?>">Review</a>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
