<?php
// app/Views/admin/hotels_index.php
use App\Core\Security;
?>
<div class="container py-3">
  <style>
    .tx-table-wrap { border: 1px solid #e9ecef; border-radius: 8px; overflow-x: auto; background: #fff; }
    .tx-table thead th { position: sticky; top: 0; background: #f8f9fa; z-index: 1; box-shadow: inset 0 -1px 0 #e9ecef; }
    .tx-toolbar { gap: .5rem; flex-wrap: wrap; background:#fff; border:1px solid #e9ecef; border-radius:10px; padding:.5rem .75rem; box-shadow: 0 1px 2px rgba(16,24,40,.04); }
    .tx-action-btn.btn { background: transparent !important; border-color: transparent !important; box-shadow: none !important; padding: .125rem .25rem; border-radius: 6px; display:inline-flex; align-items:center; justify-content:center; color:#111827; }
    .tx-action-btn i { font-size:1.05rem; color:#111827 !important; }
    .tx-action-btn.btn:hover i { color:#0d6efd !important; }
    .badge.bg-success, .badge.bg-secondary { border-radius: 999px; padding:.35em .6em; font-weight:600; letter-spacing:.2px; }
    .badge.bg-secondary { background-color:#E5E7EB !important; color:#374151; }
    .pagination .page-link { color:#334155; border-color:#E5E7EB; }
    .pagination .page-item.active .page-link { background:#2E90FA; border-color:#2E90FA; color:#fff; box-shadow: 0 1px 2px rgba(16,24,40,.12); }
    .pagination .page-item.disabled .page-link { color:#94A3B8; }
    .form-check-input.tx-status-switch { width: 2.5em; height: 1.25em; }
    .hot-thumb { width:56px; height:56px; object-fit:cover; }
    @media (max-width: 576px){
      .tx-toolbar { row-gap:.5rem; padding:.5rem; }
      .tx-toolbar .input-group { width: 100%; }
      .tx-toolbar .ms-auto { width: 100%; display:flex; flex-wrap: wrap; gap:.5rem; justify-content: space-between; }
      #hotelsStatus, #hotelsRows { flex:1 1 calc(50% - .5rem); min-width: 140px; }
    }
  </style>

  <h2 class="h5 mb-3"><i class="bi bi-building me-2"></i>Hotels Management</h2>

  <div class="d-flex justify-content-between align-items-center mb-2">
    <h4 class="mb-0 h6">Hotel List</h4>
    <div class="d-flex align-items-center gap-2">
      <button type="button" id="hotelsUnlockBtn" class="btn btn-sm btn-outline-warning" title="Enter master password to enable Delete"><i class="bi bi-shield-lock me-1"></i><?= empty($_SESSION['admin_hotels_unlocked']) ? 'Unlock Delete' : 'Unlocked' ?></button>
      <a class="btn btn-sm btn-primary" href="/admin/hotels/create" title="Add Hotel" data-bs-toggle="tooltip" aria-label="Add Hotel"><i class="bi bi-plus-circle"></i></a>
    </div>
  </div>

  <div class="d-flex tx-toolbar align-items-center mb-2">
    <div class="input-group input-group-sm" style="max-width:320px;">
      <span class="input-group-text"><i class="bi bi-search"></i></span>
      <input type="text" id="hotelsSearch" class="form-control" placeholder="Search title, vendor, city, price">
    </div>
    <div class="ms-auto d-flex gap-2 align-items-center">
      <label class="small text-muted">Status:</label>
      <select id="hotelsStatus" class="form-select form-select-sm" style="width:130px;">
        <option value="">All</option>
        <option value="Active">Active</option>
        <option value="Inactive">Inactive</option>
      </select>
      <label class="small text-muted">Rows:</label>
      <select id="hotelsRows" class="form-select form-select-sm" style="width:80px;">
        <option>10</option>
        <option selected>25</option>
        <option>50</option>
        <option>100</option>
      </select>
      <button id="hotelsExportCsv" class="btn btn-outline-secondary btn-sm" title="Export CSV" data-bs-toggle="tooltip" aria-label="Export CSV"><i class="bi bi-download"></i></button>
      <button id="hotelsExportXls" class="btn btn-outline-secondary btn-sm" title="Export Excel" data-bs-toggle="tooltip" aria-label="Export Excel"><i class="bi bi-file-earmark-excel"></i></button>
    </div>
  </div>

  <div class="table-responsive tx-table-wrap">
    <table class="table table-striped table-hover align-middle tx-table mb-0" id="adminHotelsTable">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Thumbnail</th>
          <th>Title</th>
          <th>Stars</th>
          <th>Vendor</th>
          <th>Location</th>
          <th>Base Price</th>
          <th>Status</th>
          <th>Audience</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach (($rows ?? []) as $r): ?>
          <tr>
            <td class="tx-col-idx"></td>
            <td>
              <?php if (!empty($r['thumb'])): ?>
                <img src="<?= htmlspecialchars($r['thumb']) ?>" alt="thumb" class="img-thumbnail hot-thumb">
              <?php else: ?>
                <span class="text-muted small">—</span>
              <?php endif; ?>
            </td>
            <td><?= htmlspecialchars($r['name']) ?></td>
            <td>
              <?php $s = (int)($r['stars'] ?? 0); if ($s < 0) $s = 0; if ($s > 5) $s = 5; ?>
              <?php if ($s > 0): ?>
                <?php for ($i=0; $i<$s; $i++): ?><i class="bi bi-star-fill text-warning"></i><?php endfor; ?>
                <?php for ($i=$s; $i<5; $i++): ?><i class="bi bi-star text-warning"></i><?php endfor; ?>
              <?php else: ?>
                <span class="text-muted">—</span>
              <?php endif; ?>
            </td>
            <td><?= htmlspecialchars($r['vendor']) ?></td>
            <td><?= htmlspecialchars(trim(($r['city'] ?? '').' / '.($r['country'] ?? ''), ' /')) ?></td>
            <td>
              <?php if (isset($r['base_price']) && $r['base_price'] !== null && $r['base_price'] !== ''): ?>
                <?= number_format((float)$r['base_price'], 2) ?>
              <?php else: ?>
                <span class="text-muted">—</span>
              <?php endif; ?>
            </td>
            <td>
              <?php if (isset($r['active'])): ?>
                <?php if ((int)$r['active'] === 1): ?>
                  <span class="badge text-bg-success">Active</span>
                <?php else: ?>
                  <span class="badge text-bg-secondary">Inactive</span>
                <?php endif; ?>
              <?php else: ?>
                <span class="text-muted">—</span>
              <?php endif; ?>
            </td>
            <td>
              <?php
                $vc = (int)($r['visible_customer'] ?? 1);
                $va = (int)($r['visible_agent'] ?? 1);
                $fc = (int)($r['featured_customer'] ?? 0);
                $fa = (int)($r['featured_agent'] ?? 0);
                $hotelId = (int)$r['id'];
                $csrfToken = htmlspecialchars($csrf ?? Security::csrfToken());
                function txToggleBadge($id,$field,$current,$iconOn,$iconOff,$classesOn,$classesOff,$csrf){
                  $next = $current ? 0 : 1;
                  $icon = $current ? $iconOn : $iconOff;
                  $classes = $current ? $classesOn : $classesOff;
                  return '<form method="post" action="/admin/hotels/toggle-flag" class="d-inline">
                    <input type="hidden" name="csrf" value="'.$csrf.'">
                    <input type="hidden" name="id" value="'.(int)$id.'">
                    <input type="hidden" name="field" value="'.htmlspecialchars($field).'">
                    <input type="hidden" name="value" value="'.(int)$next.'">
                    <button type="submit" class="btn btn-sm px-1 py-0 '.$classes.'" title="Toggle '.htmlspecialchars(str_replace('_',' ', $field)).'">
                      <i class="bi '.$icon.'"></i>
                    </button>
                  </form>';
                }
              ?>
              <div class="d-flex flex-column gap-1 small">
                <div>
                  <span class="me-1 fw-semibold">C:</span>
                  <?= txToggleBadge($hotelId,'visible_customer',$vc,'bi-eye','bi-eye-slash','badge bg-success-subtle border text-success','badge bg-secondary',''.$csrfToken.'') ?>
                  <?= txToggleBadge($hotelId,'featured_customer',$fc,'bi-star-fill','bi-star','badge bg-warning-subtle border text-warning','badge bg-secondary',''.$csrfToken.'') ?>
                </div>
                <div>
                  <span class="me-1 fw-semibold">A:</span>
                  <?= txToggleBadge($hotelId,'visible_agent',$va,'bi-eye','bi-eye-slash','badge bg-success-subtle border text-success','badge bg-secondary',''.$csrfToken.'') ?>
                  <?= txToggleBadge($hotelId,'featured_agent',$fa,'bi-star-fill','bi-star','badge bg-warning-subtle border text-warning','badge bg-secondary',''.$csrfToken.'') ?>
                </div>
              </div>
            </td>
            <td class="text-end">
              <a class="btn btn-outline-secondary btn-sm tx-action-btn" href="/admin/hotels/edit?id=<?= (int)$r['id'] ?>&tab=rooms" title="View Rooms" data-bs-toggle="tooltip" aria-label="View Rooms"><i class="bi bi-door-open"></i></a>
              <a class="btn btn-outline-secondary btn-sm tx-action-btn" href="/admin/hotels/edit?id=<?= (int)$r['id'] ?>" title="Edit" data-bs-toggle="tooltip" aria-label="Edit"><i class="bi bi-pencil"></i></a>
              <form method="post" action="<?= ((int)($r['active'] ?? 1) === 1) ? '/admin/hotels/disable' : '/admin/hotels/enable' ?>" class="d-inline-flex align-items-center gap-2 toggle-active-form">
                <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? Security::csrfToken()) ?>">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <div class="form-check form-switch m-0">
                  <input class="form-check-input tx-status-switch" type="checkbox"
                         role="switch"
                         data-enable-url="/admin/hotels/enable"
                         data-disable-url="/admin/hotels/disable"
                         onclick="window.txToggleHotelSwitch && window.txToggleHotelSwitch(this)"
                         <?= ((int)($r['active'] ?? 1) === 1) ? 'checked' : '' ?>
                  >
                </div>
              </form>
              <form class="d-inline" method="post" action="/admin/hotels/delete" onsubmit="return confirm('Delete this hotel?')">
                <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? Security::csrfToken()) ?>">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <button class="btn btn-outline-danger btn-sm tx-action-btn" title="Delete" data-bs-toggle="tooltip" aria-label="Delete" <?= empty($_SESSION['admin_hotels_unlocked']) ? 'disabled' : '' ?>><i class="bi bi-trash"></i></button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (empty($rows)): ?>
          <tr><td colspan="10" class="text-center text-muted py-3">No hotels yet.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
  <div class="d-flex justify-content-between align-items-center mt-2">
    <div class="small text-muted" id="hotelsCount"></div>
    <nav>
      <ul class="pagination pagination-sm mb-0" id="hotelsPager"></ul>
    </nav>
  </div>
</div>

<script>
(function(){
  const table = document.getElementById('adminHotelsTable');
  if (!table) return;
  const tbody = table.querySelector('tbody');
  const rows = Array.from(tbody.querySelectorAll('tr')).filter(tr=>!tr.querySelector('td[colspan]'));
  const search = document.getElementById('hotelsSearch');
  const rowsSel = document.getElementById('hotelsRows');
  const statusSel = document.getElementById('hotelsStatus');
  const pager = document.getElementById('hotelsPager');
  const count = document.getElementById('hotelsCount');
  const exportBtn = document.getElementById('hotelsExportCsv');
  const exportXlsBtn = document.getElementById('hotelsExportXls');

  // Determine the Status column index dynamically (1-based for nth-child)
  const headerCells = Array.from(table.querySelectorAll('thead th')).map(th => (th.textContent||'').trim().toLowerCase());
  const statusColIdx1 = (headerCells.findIndex(t => t === 'status') + 1) || 7; // fallback to old index 7

  const data = rows.map(tr => ({ tr }));
  let filtered = data.slice();
  let page = 1;
  let perPage = parseInt(rowsSel ? rowsSel.value : '25', 10) || 25;

  function normalize(s){ return (s||'').toString().toLowerCase(); }
  function rowStatus(tr){
    const badge = tr.querySelector(`td:nth-child(${statusColIdx1}) .badge`); // Status column index
    return badge ? (badge.textContent||'').trim() : '';
  }

  function applyFilter(){
    const q = normalize(search ? search.value : '');
    const wantStatus = (statusSel && statusSel.value) ? statusSel.value : '';
    filtered = data.filter(item => {
      const trTxt = normalize(item.tr.innerText);
      const matchesText = q ? trTxt.includes(q) : true;
      const matchesStatus = wantStatus ? (rowStatus(item.tr) === wantStatus) : true;
      return matchesText && matchesStatus;
    });
    page = 1; render();
  }

  function render(){
    rows.forEach(r => r.style.display = 'none');
    const total = filtered.length;
    const pages = Math.max(1, Math.ceil(total / perPage));
    if (page > pages) page = pages;
    const start = (page - 1) * perPage;
    filtered.slice(start, start + perPage).forEach((item, idx) => {
      if (item.tr) {
        item.tr.style.display = '';
        const cell = item.tr.querySelector('td.tx-col-idx');
        if (cell) cell.textContent = String(start + idx + 1);
      }
    });
    // pager
    if (pager){
      pager.innerHTML = '';
      const prev = document.createElement('li');
      prev.className = 'page-item' + (page<=1?' disabled':'');
      prev.innerHTML = '<a class="page-link" href="#" aria-label="Previous">&laquo;</a>';
      prev.onclick = (e)=>{ e.preventDefault(); if(page>1){ page--; render(); } };
      pager.appendChild(prev);
      const windowSize = 7;
      let startPage = Math.max(1, page - Math.floor(windowSize/2));
      let endPage = Math.min(pages, startPage + windowSize - 1);
      startPage = Math.max(1, endPage - windowSize + 1);
      for (let n = startPage; n <= endPage; n++){
        const li = document.createElement('li');
        li.className = 'page-item' + (n===page?' active':'');
        li.innerHTML = '<a class="page-link" href="#">'+n+'</a>';
        li.onclick = (e)=>{ e.preventDefault(); page=n; render(); };
        pager.appendChild(li);
      }
      const next = document.createElement('li');
      next.className = 'page-item' + (page>=pages?' disabled':'');
      next.innerHTML = '<a class="page-link" href="#" aria-label="Next">&raquo;</a>';
      next.onclick = (e)=>{ e.preventDefault(); if(page<pages){ page++; render(); } };
      pager.appendChild(next);
    }
    if (count) count.textContent = total + ' result' + (total===1?'':'s') + (pages>1? (' • page '+page+'/'+pages):'');
  }

  function exportCsv(){
    const headers = Array.from(table.querySelectorAll('thead th')).map(th => th.textContent.trim());
    const idxActions = headers.findIndex(h => h.toLowerCase() === 'actions');
    const headersOut = headers.filter((_,i)=> i !== idxActions);
    const visibleRows = filtered.map(item => Array.from(item.tr.children).filter((_,i)=> i !== idxActions).map(td => '"' + (td.innerText||'').replaceAll('"','""') + '"'));
    const csv = [headersOut.join(','), ...visibleRows.map(cols => cols.join(','))].join('\n');
    const blob = new Blob([csv], {type: 'text/csv;charset=utf-8;'});
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a'); a.href = url; a.download = 'hotels.csv'; a.click(); URL.revokeObjectURL(url);
  }

  function exportXls(){
    const headersAll = Array.from(table.querySelectorAll('thead th')).map(th => th.textContent.trim());
    const idxActions = headersAll.findIndex(h => h.toLowerCase() === 'actions');
    const headersOut = headersAll.filter((_,i)=> i !== idxActions);
    const rowsHtml = filtered.map(item => {
      const tds = Array.from(item.tr.children).map(td => (td.innerText||'').trim());
      const cols = tds.filter((_,i)=> i !== idxActions).map(txt => `<td>${escapeHtml(txt)}</td>`).join('');
      return `<tr>${cols}</tr>`;
    }).join('');
    const thead = `<thead><tr>${headersOut.map(h=>`<th>${escapeHtml(h)}</th>`).join('')}</tr></thead>`;
    const tbody = `<tbody>${rowsHtml}</tbody>`;
    const html = `<!DOCTYPE html><html><head><meta charset="utf-8"><meta http-equiv="X-UA-Compatible" content="IE=edge"><title>Hotels</title></head><body><table border="1">${thead}${tbody}</table></body></html>`;
    const blob = new Blob([html], { type: 'application/vnd.ms-excel' });
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a'); a.href = url; a.download = 'hotels.xls'; a.click(); URL.revokeObjectURL(url);
  }

  function escapeHtml(s){
    return (s||'').replace(/&/g,'&amp;').replace(/</g,'&lt;/').replace(/>/g,'&gt;').replace(/\"/g,'&quot;').replace(/'/g,'&#39;');
  }

  // events
  if (search) search.addEventListener('input', function(){ clearTimeout(window.__htT); window.__htT=setTimeout(applyFilter,150); });
  if (statusSel) statusSel.addEventListener('change', applyFilter);
  if (rowsSel) rowsSel.addEventListener('change', function(){ perPage = parseInt(this.value,10)||25; render(); });
  if (exportBtn) exportBtn.addEventListener('click', function(e){ e.preventDefault(); exportCsv(); });
  if (exportXlsBtn) exportXlsBtn.addEventListener('click', function(e){ e.preventDefault(); exportXls(); });

  // initial
  applyFilter();

  // Init tooltips
  if (window.bootstrap) {
    var tts = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tts.forEach(function(el){ try { new bootstrap.Tooltip(el); } catch(e){} });
  }
})();

// Robust handler for enable/disable switch (delegated + direct binding for reliability)
(function(){
  function handleToggle(sw){
    if (!sw) return;
    const form = sw.closest('form');
    if (!form) return;
    const enableUrl = sw.getAttribute('data-enable-url') || '/admin/hotels/enable';
    const disableUrl = sw.getAttribute('data-disable-url') || '/admin/hotels/disable';
    const targetUrl = sw.checked ? enableUrl : disableUrl;
    form.action = targetUrl;
    if (typeof form.requestSubmit === 'function') form.requestSubmit(); else form.submit();
  }

  const table = document.getElementById('adminHotelsTable');
  if (!table) return;
  // Delegated listener (covers dynamic rows, pagination render)
  table.addEventListener('change', function(e){
    const sw = e.target && e.target.matches && e.target.matches('input.tx-status-switch') ? e.target : (e.target.closest ? e.target.closest('input.tx-status-switch') : null);
    if (!sw) return;
    handleToggle(sw);
  });
  // Direct binding as fallback (in case change doesn't bubble in some contexts)
  const switches = table.querySelectorAll('input.tx-status-switch');
  switches.forEach(sw => {
    sw.addEventListener('change', function(){ handleToggle(sw); });
    sw.addEventListener('click', function(){ /* some browsers fire click before change */ });
  });
})();

// Unlock delete functionality with enhanced error handling
(function(){
  const btn = document.getElementById('hotelsUnlockBtn');
  if (!btn) {
    console.error('Unlock button not found');
    return;
  }

  // Add modal HTML
  const modalId = 'unlockHotelsModal';
  const toastId = 'alreadyUnlockedToast';
  
  // Create modal HTML
  const modalHTML = `
  <div class="modal fade" id="${modalId}" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Unlock Hotel Management</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form id="unlockHotelsForm" method="post" action="/admin/hotels/unlock">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? Security::csrfToken()) ?>">
          <div class="modal-body">
            <div class="mb-3">
              <label for="masterPassword" class="form-label">Enter Admin Master Password</label>
              <input type="password" class="form-control" id="masterPassword" name="master_password" required autocomplete="off">
              <div class="form-text">Enter the master password to enable delete functionality.</div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary">Unlock</button>
          </div>
        </form>
      </div>
    </div>
  </div>`;

  // Create toast HTML
  const toastHTML = `
  <div class="position-fixed bottom-0 end-0 p-3" style="z-index: 1200">
    <div id="${toastId}" class="toast" role="alert" aria-live="assertive" aria-atomic="true">
      <div class="toast-header bg-success text-white">
        <strong class="me-auto">Already Unlocked</strong>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast" aria-label="Close"></button>
      </div>
      <div class="toast-body">
        Delete functionality is already unlocked for this session.
      </div>
    </div>
  </div>`;

  // Add elements to DOM if they don't exist
  if (!document.getElementById(modalId)) {
    document.body.insertAdjacentHTML('beforeend', modalHTML);
  }
  
  if (!document.getElementById(toastId)) {
    document.body.insertAdjacentHTML('beforeend', toastHTML);
  }

  // Initialize modal and toast when button is clicked
  btn.addEventListener('click', function(e) {
    e.preventDefault();
    
    <?php if (empty($_SESSION['admin_hotels_unlocked'])): ?>
      // Show modal
      const modalEl = document.getElementById(modalId);
      if (modalEl) {
        const modal = new bootstrap.Modal(modalEl);
        modal.show();
      } else {
        console.error('Modal element not found');
        alert('Error: Could not load unlock form. Please refresh the page.');
      }
    <?php else: ?>
      // Show toast
      const toastEl = document.getElementById(toastId);
      if (toastEl) {
        const toast = new bootstrap.Toast(toastEl);
        toast.show();
      } else {
        alert('Delete functionality is already unlocked for this session.');
      }
    <?php endif; ?>
  });
})();
</script>
