<?php
// app/Views/admin/corporates/form.php
$editing = ($mode ?? 'create') === 'edit';
$action = $editing ? '/admin/corporates/update' : '/admin/corporates/store';
$corp = $corp ?? null;
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h4 mb-0"><?php echo $editing ? 'Edit Corporate' : 'New Corporate'; ?></h1>
    <div>
      <a href="/admin/corporates" class="btn btn-sm btn-outline-secondary">Back</a>
    </div>
  </div>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-info py-2"><?php echo htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>

  <div class="card shadow-sm">
    <div class="card-body">
      <form method="post" action="<?php echo $action; ?>">
        <input type="hidden" name="csrf" value="<?php echo htmlspecialchars($csrf); ?>" />
        <?php if ($editing): ?>
          <input type="hidden" name="id" value="<?php echo (int)$corp['id']; ?>" />
        <?php endif; ?>
        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label">Company Name</label>
            <input type="text" name="company_name" class="form-control" value="<?php echo htmlspecialchars($corp['company_name'] ?? ''); ?>" required />
          </div>
          <div class="col-md-3">
            <label class="form-label">Discount %</label>
            <input type="number" step="0.01" min="0" name="discount_percent" class="form-control" value="<?php echo htmlspecialchars($corp['discount_percent'] ?? ''); ?>" required />
          </div>
          <div class="col-12">
            <button type="submit" class="btn btn-primary"><?php echo $editing ? 'Update' : 'Create'; ?></button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
