<div class="container-xxl py-3">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h1 class="h4 mb-0">Company Bank Accounts</h1>
      <div class="text-muted small">Manage company receiving accounts shown to agents for deposits</div>
    </div>
    <div class="btn-group">
      <a href="/admin/wallet/deposits" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i> Back to Deposits</a>
      <a href="/admin/bank-accounts/create" class="btn btn-primary"><i class="bi bi-plus-lg me-1"></i> Add Account</a>
    </div>
  </div>

  <?php if (!empty($_SESSION['flash_error'])): ?>
    <div class="alert alert-danger border-0 shadow-sm mb-3"><?php echo htmlspecialchars($_SESSION['flash_error']); unset($_SESSION['flash_error']); ?></div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['flash_success'])): ?>
    <div class="alert alert-success border-0 shadow-sm mb-3"><?php echo htmlspecialchars($_SESSION['flash_success']); unset($_SESSION['flash_success']); ?></div>
  <?php endif; ?>

  <div class="card card-elevated">
    <div class="card-body">
      <form method="get" class="row g-3 mb-3">
        <div class="col-sm-6 col-md-4">
          <label class="form-label">Search</label>
          <input type="text" name="q" value="<?php echo htmlspecialchars($q ?? ''); ?>" class="form-control" />
        </div>
        <div class="col-sm-6 col-md-3">
          <label class="form-label">Active</label>
          <select name="active" class="form-select">
            <option value="">All</option>
            <option value="1" <?php echo (($active ?? '')==='1')?'selected':''; ?>>Active</option>
            <option value="0" <?php echo (($active ?? '')==='0')?'selected':''; ?>>Inactive</option>
          </select>
        </div>
        <div class="col-md-3 d-flex align-items-end">
          <button type="submit" class="btn btn-outline-primary"><i class="bi bi-search me-1"></i> Filter</button>
          <a href="/admin/bank-accounts" class="btn btn-outline-secondary ms-2">Reset</a>
        </div>
      </form>
      <div class="table-responsive">
        <table class="table align-middle mb-0">
          <thead class="table-light">
            <tr>
              <th scope="col">#</th>
              <th scope="col">Bank</th>
              <th scope="col">Account Name</th>
              <th scope="col">Account Number</th>
              <th scope="col">Currency</th>
              <th scope="col">Active</th>
              <th scope="col" class="text-end">Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach (($rows ?? []) as $r): ?>
              <tr>
                <td class="px-4 py-3 text-sm">#<?php echo (int)$r['id']; ?></td>
                <td class="px-4 py-3 text-sm"><?php echo htmlspecialchars($r['bank_name']); ?></td>
                <td class="px-4 py-3 text-sm"><?php echo htmlspecialchars($r['account_name']); ?></td>
                <td class="px-4 py-3 text-sm font-mono"><?php echo htmlspecialchars($r['account_number']); ?></td>
                <td class="px-4 py-3 text-sm"><?php echo htmlspecialchars($r['currency']); ?></td>
                <td class="px-4 py-3 text-sm"><?php echo ((int)$r['active']===1)?'Yes':'No'; ?></td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-primary me-1" href="/admin/bank-accounts/edit?id=<?php echo (int)$r['id']; ?>"><i class="bi bi-pencil-square me-1"></i>Edit</a>
                  <form action="/admin/bank-accounts/toggle" method="post" class="d-inline">
                    <input type="hidden" name="csrf" value="<?php echo \App\Core\Security::csrfToken(); ?>" />
                    <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>" />
                    <button class="btn btn-sm btn-outline-secondary me-1" type="submit"><?php echo ((int)$r['active']===1)?'Disable':'Enable'; ?></button>
                  </form>
                  <form action="/admin/bank-accounts/delete" method="post" class="d-inline" onsubmit="return confirm('Delete this account?');">
                    <input type="hidden" name="csrf" value="<?php echo \App\Core\Security::csrfToken(); ?>" />
                    <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>" />
                    <button class="btn btn-sm btn-outline-danger" type="submit">Delete</button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (empty($rows)): ?>
              <tr><td colspan="7" class="text-center text-muted py-5">No accounts</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
