<?php
// app/Views/admin/categories_create.php
?>
<div class="container py-2">
  <h2 class="h5 mb-3"><i class="bi bi-tags me-2"></i>Modules</h2>
  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success py-2">
      <?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?>
    </div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2">
      <ul class="mb-0 small">
        <?php foreach (($_SESSION['errors'] ?? []) as $e): ?>
          <li><?= htmlspecialchars($e) ?></li>
        <?php endforeach; unset($_SESSION['errors']); ?>
      </ul>
    </div>
  <?php endif; ?>

  <?php if (empty($unlocked)): ?>
    <div class="d-flex justify-content-center align-items-center" style="min-height:50vh;">
      <div class="card" style="width:min(92vw,420px)">
        <div class="card-header fw-semibold">Enter Update Password</div>
        <form method="post" action="/admin/categories/unlock">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
          <div class="card-body">
            <p class="small text-muted mb-2">This page is protected. Please enter your update password to continue.</p>
            <input type="password" name="master_password" class="form-control" placeholder="Update Password" autocomplete="current-password" required>
          </div>
          <div class="card-footer d-grid">
            <button type="submit" class="btn btn-primary">Unlock</button>
          </div>
        </form>
      </div>
    </div>
  <?php else: ?>
  <div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
      <span>Add Module</span>
      <form class="row g-2 align-items-end" method="post" action="/admin/categories/store">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
        <input type="hidden" name="master_password" value="">
        <div class="col-auto">
          <label class="form-label">Module Name</label>
          <input type="text" name="name" class="form-control form-control-sm" placeholder="e.g., Taxi" required>
        </div>
        <div class="col-auto">
          <button class="btn btn-sm btn-primary mt-4 js-ask-pass" data-action="add-module" type="button">Add</button>
        </div>
      </form>
    </div>
    <div class="card-body">
      <div class="d-flex justify-content-between align-items-center mb-2">
        <div class="input-group input-group-sm" style="max-width:320px;">
          <span class="input-group-text"><i class="bi bi-search"></i></span>
          <input id="modulesSearch" type="text" class="form-control" placeholder="Search module name or slug..." autocomplete="off">
        </div>
        <div class="d-flex align-items-center gap-2">
          <label class="small text-muted mb-0">Rows:</label>
          <select id="modulesPageSize" class="form-select form-select-sm" style="width:auto;">
            <option value="10" selected>10</option>
            <option value="25">25</option>
            <option value="50">50</option>
            <option value="100">100</option>
          </select>
        </div>
      </div>
      <div class="table-responsive">
        <table class="table table-sm align-middle" id="modulesTable">
          <thead class="table-light">
            <tr>
              <th style="width:45%">Name</th>
              <th style="width:35%">Slug</th>
              <th style="width:20%" class="text-end">Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach (($modules ?? []) as $m): ?>
              <tr>
                <td>
                  <form id="f_mod_<?= (int)$m['id'] ?>" method="post" action="/admin/categories/update">
                    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
                    <input type="hidden" name="id" value="<?= (int)$m['id'] ?>">
                    <input type="hidden" name="master_password" value="">
                  </form>
                  <input form="f_mod_<?= (int)$m['id'] ?>" type="text" class="form-control form-control-sm" name="name" value="<?= htmlspecialchars($m['name']) ?>" placeholder="Module name">
                </td>
                <td class="text-muted"><?= htmlspecialchars($m['slug']) ?></td>
                <td class="text-end">
                  <div class="btn-group btn-group-sm" role="group">
                    <button data-action="update-module" data-form="f_mod_<?= (int)$m['id'] ?>" class="btn btn-outline-primary js-ask-pass" type="button">Save</button>
                  </div>
                  <form class="d-inline" method="post" action="/admin/categories/delete">
                    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
                    <input type="hidden" name="id" value="<?= (int)$m['id'] ?>">
                    <input type="hidden" name="master_password" value="">
                    <button data-action="delete-module" class="btn btn-sm btn-outline-danger js-ask-pass" type="button">Delete</button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="d-flex justify-content-between align-items-center mt-2">
        <div class="small text-muted">
          <span id="modulesPageInfo">Showing 0 to 0 of 0</span>
        </div>
        <nav>
          <ul class="pagination pagination-sm mb-0" id="modulesPager">
            <li class="page-item"><button class="page-link" id="modulesPrev" type="button">Previous</button></li>
            <li class="page-item disabled"><span class="page-link" id="modulesCurr">1</span></li>
            <li class="page-item"><button class="page-link" id="modulesNext" type="button">Next</button></li>
          </ul>
        </nav>
      </div>
    </div>
  </div>
  <?php endif; ?>

  <script>
    (function(){
      // Lightweight Update Password modal (shared pattern)
      let targetForm = null;
      let overlay=null, modal=null, desc=null, input=null, okBtn=null, cancelBtn=null;
      function ensureModal(){
        if (overlay) return;
        overlay = document.createElement('div');
        overlay.style.cssText='position:fixed;inset:0;background:rgba(0,0,0,.4);display:none;z-index:20000;';
        modal = document.createElement('div');
        modal.style.cssText='position:fixed;left:50%;top:50%;transform:translate(-50%,-50%);background:#fff;border-radius:8px;box-shadow:0 10px 30px rgba(0,0,0,.2);width:min(92vw,380px);z-index:20001;';
        const hdr=document.createElement('div'); hdr.style.cssText='padding:10px 12px;border-bottom:1px solid #eee;font-weight:600;display:flex;justify-content:space-between;align-items:center;'; hdr.textContent='Enter Update Password';
        const x=document.createElement('button'); x.type='button'; x.textContent='×'; x.style.cssText='border:0;background:transparent;font-size:20px;line-height:1;cursor:pointer;'; hdr.appendChild(x);
        const body=document.createElement('div'); body.style.cssText='padding:12px 12px 0 12px;';
        desc=document.createElement('p'); desc.className='small'; desc.style.margin='0 0 8px 0'; desc.textContent='This action requires your update password.';
        input=document.createElement('input'); input.type='password'; input.placeholder='Update Password'; input.autocomplete='current-password'; input.style.cssText='width:100%;padding:8px;border:1px solid #ced4da;border-radius:6px;';
        body.appendChild(desc); body.appendChild(input);
        const ftr=document.createElement('div'); ftr.style.cssText='padding:10px 12px;display:flex;justify-content:flex-end;gap:8px;border-top:1px solid #eee;margin-top:12px;';
        cancelBtn=document.createElement('button'); cancelBtn.type='button'; cancelBtn.textContent='Cancel'; cancelBtn.style.cssText='padding:6px 10px;border:1px solid #ced4da;background:#fff;border-radius:6px;cursor:pointer;';
        okBtn=document.createElement('button'); okBtn.type='button'; okBtn.textContent='Confirm'; okBtn.style.cssText='padding:6px 10px;border:1px solid #0d6efd;background:#0d6efd;color:#fff;border-radius:6px;cursor:pointer;';
        ftr.appendChild(cancelBtn); ftr.appendChild(okBtn);
        modal.appendChild(hdr); modal.appendChild(body); modal.appendChild(ftr);
        document.body.appendChild(overlay); document.body.appendChild(modal);
        function hide(){ overlay.style.display='none'; modal.style.display='none'; }
        function show(){ overlay.style.display='block'; modal.style.display='block'; setTimeout(()=>input.focus(),50); }
        overlay.addEventListener('click', hide); x.addEventListener('click', hide); cancelBtn.addEventListener('click', hide);
        okBtn.addEventListener('click', ()=>{
          if (!targetForm) return; const pwd=(input.value||'').trim(); if (!pwd) { input.focus(); return; }
          let hidden=targetForm.querySelector('input[name="master_password"]'); if (!hidden){ hidden=document.createElement('input'); hidden.type='hidden'; hidden.name='master_password'; targetForm.appendChild(hidden); }
          hidden.value=pwd; setTimeout(()=>{ targetForm.submit(); setTimeout(()=>hide(), 50); },0);
        });
        input.addEventListener('keydown', (e)=>{ if(e.key==='Enter'){ e.preventDefault(); okBtn.click(); }});
        document.addEventListener('keydown', (e)=>{ if(e.key==='Escape') hide(); });
        overlay.show=show; overlay.hide=hide;
      }
      function openPass(actionLabel, form){ targetForm=form; ensureModal(); desc.textContent = `Please enter your update password to ${actionLabel}.`; try{ overlay.show(); }catch(e){ const pwd=window.prompt('Enter Update Password'); if(!pwd) return; let hidden=form.querySelector('input[name="master_password"]'); if(!hidden){ hidden=document.createElement('input'); hidden.type='hidden'; hidden.name='master_password'; form.appendChild(hidden);} hidden.value=pwd.trim(); form.submit(); } }
      document.addEventListener('click', (ev)=>{
        const btn=ev.target.closest('.js-ask-pass'); if(!btn) return;
        let form=null; if(btn.dataset.form) form=document.getElementById(btn.dataset.form); if(!form) form=btn.closest('form'); if(!form){ alert('No form found.'); return; }
        const action=btn.dataset.action||'proceed'; openPass(action.replace('-', ' '), form);
      });
    })();
  </script>
  <script>
    (function(){
      // Modules table search + pagination (same logic as tools page tables)
      const table = document.getElementById('modulesTable');
      if (!table) return;
      const rowsAll = Array.from(table.tBodies[0].rows);
      const searchInput = document.getElementById('modulesSearch');
      const pageSizeSel = document.getElementById('modulesPageSize');
      const prevBtn = document.getElementById('modulesPrev');
      const nextBtn = document.getElementById('modulesNext');
      const currSpan = document.getElementById('modulesCurr');
      const pageInfo = document.getElementById('modulesPageInfo');
      const state = { q: '', page: 1, pageSize: parseInt(pageSizeSel?.value || '10', 10) };

      function matches(row, q){ if (!q) return true; return row.innerText.toLowerCase().includes(q.toLowerCase()); }
      function render(){
        const filtered = rowsAll.filter(r => matches(r, state.q));
        const total = filtered.length;
        const pages = Math.max(1, Math.ceil(total / state.pageSize));
        if (state.page > pages) state.page = pages;
        const start = (state.page - 1) * state.pageSize;
        const end = start + state.pageSize;
        rowsAll.forEach(r => r.style.display = 'none');
        filtered.slice(start, end).forEach(r => r.style.display = '');
        currSpan.textContent = String(state.page);
        prevBtn.parentElement.classList.toggle('disabled', state.page <= 1);
        nextBtn.parentElement.classList.toggle('disabled', state.page >= pages);
        const from = total === 0 ? 0 : start + 1; const to = Math.min(total, end);
        pageInfo.textContent = `Showing ${from} to ${to} of ${total}`;
      }
      searchInput?.addEventListener('input', ()=>{ state.q = searchInput.value.trim(); state.page = 1; render(); });
      pageSizeSel?.addEventListener('change', ()=>{ state.pageSize = parseInt(pageSizeSel.value,10) || 10; state.page = 1; render(); });
      prevBtn?.addEventListener('click', ()=>{ if (state.page > 1) { state.page--; render(); } });
      nextBtn?.addEventListener('click', ()=>{ state.page++; render(); });
      render();
    })();
  </script>
</div>
