<?php
/** @var string $csrf */
/** @var array $rows */
/** @var array $users */
/** @var array $types */
/** @var array $actions */
/** @var int|null $userId */
/** @var int|null $orderId */
/** @var string $eventType */
/** @var string $action */
/** @var int|null $statusCode */
/** @var string $from */
/** @var string $to */
/** @var string $ipLike */
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Security Audit Events</title>
  <link href="/bootstrap-5.3.7-dist/bootstrap-5.3.7-dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .table-fixed { table-layout: fixed; }
    .wrap { word-wrap: break-word; white-space: pre-wrap; }
    .mono { font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; font-size: 12px; }
    .sticky-top-2 { position: sticky; top: 0.5rem; z-index: 1020; }
  </style>
</head>
<body class="bg-light">
<div class="container-fluid py-3">
  <div class="d-flex align-items-center mb-3">
    <h3 class="mb-0">Security Audit Events</h3>
  </div>

  <form class="card card-body mb-3" method="get" action="">
    <input type="hidden" name="_token" value="<?= htmlspecialchars($csrf) ?>">
    <div class="row g-2">
      <div class="col-md-2">
        <label class="form-label">User</label>
        <select class="form-select" name="user_id">
          <option value="">All</option>
          <?php foreach ($users as $u): ?>
            <option value="<?= (int)$u['id'] ?>" <?= ($userId===(int)$u['id'])?'selected':'' ?>>
              <?= htmlspecialchars(($u['name'] ?? 'User').' ('.($u['email'] ?? '').')') ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">Order ID</label>
        <input type="number" class="form-control" name="order_id" value="<?= htmlspecialchars((string)($orderId ?? '')) ?>">
      </div>
      <div class="col-md-2">
        <label class="form-label">Event Type</label>
        <select class="form-select" name="event_type">
          <option value="">All</option>
          <?php foreach ($types as $t): ?>
            <option value="<?= htmlspecialchars($t) ?>" <?= ($eventType===$t)?'selected':'' ?>><?= htmlspecialchars($t) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">Action</label>
        <select class="form-select" name="action">
          <option value="">All</option>
          <?php foreach ($actions as $a): ?>
            <option value="<?= htmlspecialchars($a) ?>" <?= ($action===$a)?'selected':'' ?>><?= htmlspecialchars($a) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">Status Code</label>
        <input type="number" class="form-control" name="status_code" value="<?= htmlspecialchars((string)($statusCode ?? '')) ?>" placeholder="e.g. 422">
      </div>
      <div class="col-md-2">
        <label class="form-label">IP contains</label>
        <input type="text" class="form-control" name="ip" value="<?= htmlspecialchars($ipLike ?? '') ?>" placeholder="192.168">
      </div>
      <div class="col-md-2">
        <label class="form-label">From</label>
        <input type="date" class="form-control" name="from" value="<?= htmlspecialchars($from ?? '') ?>">
      </div>
      <div class="col-md-2">
        <label class="form-label">To</label>
        <input type="date" class="form-control" name="to" value="<?= htmlspecialchars($to ?? '') ?>">
      </div>
      <div class="col-md-2 align-self-end">
        <button class="btn btn-primary w-100" type="submit">Filter</button>
      </div>
      <div class="col-md-2 align-self-end">
        <a class="btn btn-secondary w-100" href="/admin/audit/security">Reset</a>
      </div>
    </div>
  </form>

  <div class="card">
    <div class="table-responsive">
      <table class="table table-sm table-striped table-hover align-middle table-fixed">
        <thead class="table-light sticky-top">
          <tr>
            <th style="width:70px">ID</th>
            <th style="width:120px">Time</th>
            <th style="width:90px">User</th>
            <th style="width:90px">Order</th>
            <th style="width:160px">Type</th>
            <th style="width:160px">Action</th>
            <th style="width:80px">Code</th>
            <th style="width:140px">IP</th>
            <th style="width:160px">Route</th>
            <th>Message</th>
            <th style="width:380px">Details</th>
          </tr>
        </thead>
        <tbody class="mono">
        <?php if (!$rows): ?>
          <tr><td colspan="11" class="text-center py-4">No audit events</td></tr>
        <?php else: ?>
          <?php foreach ($rows as $r): ?>
            <?php $details = json_decode($r['details'] ?? 'null', true); ?>
            <tr>
              <td><?= (int)$r['id'] ?></td>
              <td><span title="<?= htmlspecialchars($r['created_at']) ?>"><?= htmlspecialchars(substr($r['created_at'],0,19)) ?></span></td>
              <td>
                <?php if ($r['user_id']): ?>
                  <div><?= (int)$r['user_id'] ?></div>
                  <div class="text-muted small wrap"><?= htmlspecialchars(($r['user_name'] ?? '').' '.($r['user_email'] ?? '')) ?></div>
                <?php endif; ?>
              </td>
              <td><?= (int)($r['order_id'] ?? 0) ?></td>
              <td class="wrap"><?= htmlspecialchars($r['event_type'] ?? '') ?></td>
              <td class="wrap"><?= htmlspecialchars($r['action'] ?? '') ?></td>
              <td><?= htmlspecialchars((string)($r['status_code'] ?? '')) ?></td>
              <td>
                <div class="wrap" title="UA: <?= htmlspecialchars($r['user_agent'] ?? '') ?>">
                  <?= htmlspecialchars($r['ip'] ?? '') ?>
                </div>
              </td>
              <td class="wrap"><div class="text-muted small"><?= htmlspecialchars(($r['method'] ?? '').' '.($r['route'] ?? '')) ?></div></td>
              <td class="wrap"><?= htmlspecialchars($r['message'] ?? '') ?></td>
              <td class="wrap">
                <?php if (is_array($details) && $details): ?>
                  <pre class="mb-0 mono"><?= htmlspecialchars(json_encode($details, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES)) ?></pre>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<script src="/bootstrap-5.3.7-dist/bootstrap-5.3.7-dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
