<?php /** @var string $csrf */ /** @var array $logs */ /** @var array $users */ /** @var array $actions */ /** @var int|null $userId */ /** @var string $action */ /** @var string $from */ /** @var string $to */ ?>
<div class="container py-3">
  <h4 class="mb-3">Audit Logs</h4>
  <form class="row g-2 mb-3" method="get" action="/admin/audit/logs">
    <div class="col-md-3">
      <label class="form-label">User</label>
      <select name="user_id" class="form-select">
        <option value="">All Users</option>
        <?php foreach ($users as $u): $sel = ($userId && (int)$userId === (int)$u['id']) ? 'selected' : ''; ?>
          <option value="<?= (int)$u['id'] ?>" <?= $sel ?>><?= htmlspecialchars($u['name'].' ('.$u['email'].')') ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">Action</label>
      <select name="action" class="form-select">
        <option value="">All Actions</option>
        <?php foreach ($actions as $a): $sel = ($action === $a) ? 'selected' : ''; ?>
          <option value="<?= htmlspecialchars($a) ?>" <?= $sel ?>><?= htmlspecialchars($a) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-2">
      <label class="form-label">From</label>
      <input type="date" class="form-control" name="from" value="<?= htmlspecialchars($from) ?>">
    </div>
    <div class="col-md-2">
      <label class="form-label">To</label>
      <input type="date" class="form-control" name="to" value="<?= htmlspecialchars($to) ?>">
    </div>
    <div class="col-md-2 d-flex align-items-end">
      <button class="btn btn-primary w-100">Filter</button>
    </div>
  </form>

  <div class="table-responsive">
    <table class="table table-sm table-striped align-middle">
      <thead>
        <tr>
          <th>ID</th>
          <th>Date</th>
          <th>User</th>
          <th>IP</th>
          <th>Action</th>
          <th>Details</th>
        </tr>
      </thead>
      <tbody>
        <?php if (!$logs): ?>
          <tr><td colspan="6" class="text-center text-muted">No logs</td></tr>
        <?php else: ?>
          <?php foreach ($logs as $log): $meta = json_decode($log['meta'] ?? '[]', true) ?: []; ?>
            <tr>
              <td><?= (int)$log['id'] ?></td>
              <td><?= htmlspecialchars($log['created_at']) ?></td>
              <td>
                <?php if (!empty($log['user_id'])): ?>
                  <?= htmlspecialchars(($log['name'] ?? 'User').' ('.$log['email'].')') ?>
                <?php else: ?>
                  <span class="text-muted">N/A</span>
                <?php endif; ?>
              </td>
              <td>
                <div><?= htmlspecialchars($log['ip'] ?? '') ?></div>
                <?php if (!empty($meta['x_forwarded_for'])): ?>
                  <div class="small text-muted">XFF: <?= htmlspecialchars($meta['x_forwarded_for']) ?></div>
                <?php endif; ?>
              </td>
              <td><?= htmlspecialchars($log['action']) ?></td>
              <td class="small">
                <?php foreach (['amount','from','to_user_id','partner_id','email','request_uri','user_agent','ok'] as $k): if (isset($meta[$k])): ?>
                  <div><strong><?= htmlspecialchars($k) ?>:</strong> <?= htmlspecialchars(is_bool($meta[$k]) ? ($meta[$k] ? 'true' : 'false') : (string)$meta[$k]) ?></div>
                <?php endif; endforeach; ?>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
