<?php
// app/Views/admin/airports_index.php
$unlocked = !empty($unlocked);
?>
<div class="container py-3">
  <h2 class="h5 mb-3 d-flex align-items-center">
    <i class="bi bi-airplane me-2"></i>
    Airports
  </h2>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success py-2 small mb-2"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2 small mb-2">
      <?php foreach ($_SESSION['errors'] as $e): ?><div><?= htmlspecialchars($e) ?></div><?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <?php if (!$unlocked): ?>
    <form method="post" action="/admin/airports/unlock" class="mb-3">
      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
      <div class="alert alert-info small d-flex justify-content-between align-items-center">
        <div>Enter update password to manage airports.</div>
        <button class="btn btn-sm btn-primary">Unlock</button>
      </div>
    </form>
  <?php else: ?>
    <div class="d-flex justify-content-between mb-2">
      <div></div>
      <a href="/admin/airports/create" class="btn btn-sm btn-primary"><i class="bi bi-plus"></i> Add Airport</a>
    </div>
    <div class="table-responsive">
      <table class="table table-sm table-striped align-middle">
        <thead class="table-light">
          <tr>
            <th style="width:90px">Code</th>
            <th>Name</th>
            <th style="width:160px">City</th>
            <th style="width:160px">Country</th>
            <th style="width:140px"></th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($rows)): foreach ($rows as $r): ?>
            <tr>
              <td><code><?= htmlspecialchars((string)($r['code'] ?? '')) ?></code></td>
              <td><?= htmlspecialchars((string)($r['name'] ?? '')) ?></td>
              <td><?= htmlspecialchars((string)($r['city'] ?? '')) ?></td>
              <td><?= htmlspecialchars((string)($r['country'] ?? '')) ?></td>
              <td class="text-end">
                <a class="btn btn-sm btn-outline-secondary" href="/admin/airports/edit?id=<?= (int)($r['id'] ?? 0) ?>">Edit</a>
                <form method="post" action="/admin/airports/delete" class="d-inline" onsubmit="return confirm('Delete this airport?');">
                  <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                  <input type="hidden" name="id" value="<?= (int)($r['id'] ?? 0) ?>">
                  <button class="btn btn-sm btn-outline-danger">Delete</button>
                </form>
              </td>
            </tr>
          <?php endforeach; else: ?>
            <tr><td colspan="5" class="text-center text-muted small">No airports added yet.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>
