<?php
$router->get('/file/wallet-deposit', 'FileController@walletDeposit'); // ?id=<request_id>
$router->get('/admin/bank-accounts', 'CompanyBankAccountsAdminController@index');
$router->get('/admin/bank-accounts/create', 'CompanyBankAccountsAdminController@create');
$router->post('/admin/bank-accounts/store', 'CompanyBankAccountsAdminController@store');
$router->get('/admin/bank-accounts/edit', 'CompanyBankAccountsAdminController@edit'); // ?id=
$router->post('/admin/bank-accounts/update', 'CompanyBankAccountsAdminController@update');
$router->post('/admin/bank-accounts/toggle', 'CompanyBankAccountsAdminController@toggle');
$router->post('/admin/bank-accounts/delete', 'CompanyBankAccountsAdminController@delete');
// app/Routes/web.php
// Define web routes here
$router->get('/', 'HomeController@index');
$router->get('/login', 'AuthController@login');
$router->post('/login', 'AuthController@doLogin');
$router->get('/login/select', 'AuthController@select');
$router->get('/login/admin', 'AuthController@loginAdmin');
$router->post('/login/admin', 'AuthController@doLoginAdmin');
$router->get('/login/employee', 'AuthController@loginEmployee');
$router->post('/login/employee', 'AuthController@doLoginEmployee');
$router->get('/login/partner', 'AuthController@loginPartner');
$router->post('/login/partner', 'AuthController@doLoginPartner');
// [agent removed] Login routes disabled
// $router->get('/login/agent', 'AuthController@loginAgent');
// $router->post('/login/agent', 'AuthController@doLoginAgent');
$router->get('/login/customer', 'AuthController@loginCustomer');
$router->post('/login/customer', 'AuthController@doLoginCustomer');
$router->get('/logout', 'AuthController@logout');

// === Public Verification Routes ===
// Universal verification page (supports Taxi now; Hotel/Activity later)
$router->get('/verify', 'VerifyController@index');
// Taxi verification (public) + legacy alias under /b2b
$router->get('/taxi/verify', 'TaxiController@verify');
$router->get('/b2b/taxi/verify', 'TaxiController@verify');
// Activity verification (public) + legacy alias under /b2b
$router->get('/activity/verify', 'ActivityAgentController@verify');
$router->get('/b2b/activity/verify', 'ActivityAgentController@verify');

$router->get('/users', 'UsersController@index');
$router->get('/users/create', 'UsersController@create');
$router->post('/users/store', 'UsersController@store');
$router->get('/users/edit', 'UsersController@edit');
$router->post('/users/update', 'UsersController@update');
$router->post('/users/delete', 'UsersController@delete');

$router->get('/hotels', 'HotelsController@index');
$router->get('/hotels/create', 'HotelsController@create');
$router->post('/hotels/store', 'HotelsController@store');
$router->get('/hotels/edit', 'HotelsController@edit');
$router->post('/hotels/update', 'HotelsController@update');
$router->post('/hotels/delete', 'HotelsController@delete');

// Admin area
$router->get('/admin', 'AdminController@index');

// Admin wallet tools
$router->get('/admin/wallet/manual', 'AdminController@walletManualForm');
$router->post('/admin/wallet/manual', 'AdminController@walletManualStore');
$router->get('/admin/wallet/ledger', 'AdminController@walletLedger');

// Admin Secure Wallet Operations
$router->get('/admin/wallet/secure', 'AdminController@walletSecure');
$router->post('/admin/wallet/secure/seed', 'AdminController@walletSeed');
$router->post('/admin/wallet/secure/admin-to-agent', 'AdminController@transferAdminToAgent');
$router->post('/admin/wallet/secure/admin-to-partner', 'AdminController@transferAdminToPartner');
$router->post('/admin/wallet/secure/partner-to-agent', 'AdminController@transferPartnerToAgent');
// Reversals (compensating entries)
$router->post('/admin/wallet/secure/reverse/admin-agent', 'AdminController@reverseAdminAgent');
$router->post('/admin/wallet/secure/reverse/admin-partner', 'AdminController@reverseAdminPartner');
$router->post('/admin/wallet/secure/reverse/partner-agent', 'AdminController@reversePartnerAgent');

// Admin lightweight API for UI helpers
$router->get('/admin/api/agents-by-partner', 'AdminController@apiAgentsByPartner'); // ?partner_id=
$router->get('/admin/api/user-balance', 'AdminController@apiUserBalance'); // ?user_id=
$router->get('/admin/api/partner-balance', 'AdminController@apiPartnerBalance'); // ?partner_id=
$router->get('/admin/api/wallet-secure-stats', 'AdminController@apiWalletSecureStats');

// Admin Audit Logs
$router->get('/admin/audit/logs', 'AdminController@auditLogs');
// Admin Security Audit (wallet/PIN/payment)
$router->get('/admin/audit/security', 'AdminController@auditSecurity');

// Admin Promo Codes
$router->get('/admin/promos', 'PromoController@index');
$router->get('/admin/promos/create', 'PromoController@create');
$router->post('/admin/promos/store', 'PromoController@store');
$router->get('/admin/promos/edit', 'PromoController@edit'); // expects ?id=
$router->post('/admin/promos/update', 'PromoController@update');
$router->post('/admin/promos/delete', 'PromoController@delete');

// Admin Corporate Accounts
$router->get('/admin/corporates', 'CorporateController@index');
$router->get('/admin/corporates/create', 'CorporateController@create');
$router->post('/admin/corporates/store', 'CorporateController@store');
$router->get('/admin/corporates/edit', 'CorporateController@edit'); // expects ?id=
$router->post('/admin/corporates/update', 'CorporateController@update');
$router->post('/admin/corporates/delete', 'CorporateController@delete');

// Role dashboards
$router->get('/employee', 'EmployeeController@index');
$router->get('/partner', 'PartnerController@index');
// [agent removed] Agent dashboard pages disabled
// $router->get('/agent', 'AgentController@index');
// $router->get('/agent/wallet', 'AgentController@wallet');
// $router->get('/agent/bookings', 'AgentController@bookings');
// $router->get('/agent/orders', 'AgentController@orders');
// $router->get('/agent/orders/view', 'AgentController@orderView');
// $router->get('/agent/support', 'AgentController@support');
// [agent removed] Agent listing/detail pages disabled
// $router->get('/agent/activities', 'AgentController@activities');
// $router->get('/agent/taxis', 'AgentController@taxis');
// $router->get('/agent/packages', 'AgentController@packages');
// $router->get('/agent/yachts', 'AgentController@yachts');
// $router->get('/agent/hotels', 'AgentController@hotels');
// $router->get('/agent/hotel/detail', 'AgentController@hotelDetail');
// $router->get('/agent/activities/detail', 'AgentController@activityDetail');
// Initiate checkout/payment for a specific pending booking
// [agent removed] Booking routes disabled
// $router->get('/agent/booking/pay', 'AgentController@bookingPay'); // expects ?id=
// $router->get('/agent/booking/view', 'AgentController@bookingView'); // expects ?id=
// $router->post('/agent/booking/create/activity', 'AgentController@createActivityBooking');
// $router->post('/agent/booking/create/hotel', 'AgentController@createHotelBooking');
// $router->get('/agent/booking/guest-info', 'AgentController@bookingGuestInfo'); // expects ?id=
// $router->post('/agent/booking/guest-info', 'AgentController@bookingGuestInfoSave');
$router->get('/customer', 'CustomerController@index');
// [agent removed] B2B alias to AgentController disabled
// $router->get('/b2b', 'AgentController@index');
$router->get('/b2c', 'CustomerController@index');

// ===== Admin Top Menu: Booking =====
$router->get('/admin/booking/activity/create', 'BookingController@activityCreate');
$router->get('/admin/booking/hotel', 'BookingController@hotel');
$router->get('/admin/booking/taxi', 'BookingController@taxi');
$router->get('/admin/booking/evisa', 'BookingController@evisa');

// ===== Admin Top Menu: Vendor Management =====
$router->get('/admin/vendors/create', 'VendorsController@create');
$router->post('/admin/vendors/store', 'VendorsController@store');
$router->post('/admin/vendors/update', 'VendorsController@update');
$router->post('/admin/vendors/delete', 'VendorsController@delete');
$router->get('/admin/vendors/activity/create', 'VendorsController@activityCreate');
$router->get('/admin/vendors/hotels', 'VendorsController@hotels');
$router->get('/admin/vendors/taxies', 'VendorsController@taxies');
$router->get('/admin/vendors/evisa', 'VendorsController@evisa');

// ===== Admin: Vendor Packages (index removed per request) =====
$router->post('/admin/vendor-packages/store', 'PackagesController@store');
$router->post('/admin/vendor-packages/delete', 'PackagesController@delete');
$router->post('/admin/vendor-packages/toggle-active', 'PackagesController@togglePackageActive');
$router->post('/admin/vendor-package-variants/store', 'PackagesController@variantStore');
$router->post('/admin/vendor-package-variants/delete', 'PackagesController@variantDelete');
$router->post('/admin/vendor-package-variants/toggle-active', 'PackagesController@toggleVariantActive');
$router->post('/admin/vendor-package-prices/store', 'PackagesController@priceStore');
$router->post('/admin/vendor-package-prices/delete', 'PackagesController@priceDelete');
// Admin: Vendor package transport options (fixed price)
$router->post('/admin/vendor-packages/transport/toggle', 'PackagesController@transportToggle');
$router->post('/admin/vendor-packages/transport/store', 'PackagesController@transportOptionStore');
$router->post('/admin/vendor-packages/transport/toggle-active', 'PackagesController@transportOptionToggle');
$router->post('/admin/vendor-packages/transport/delete', 'PackagesController@transportOptionDelete');

// Dedicated manage page for a single vendor package (requested path)
// Prefer extensionless path to avoid Apache trying to serve a physical .php
$router->get('/admin/vendors/activity/package_manage', 'PackagesController@manage'); // expects ?id=
// Aliases to support older/alternate links
$router->get('/admin/vendors/package_manage', 'PackagesController@manage'); // expects ?id=
$router->get('/vendors/activity/package_manage', 'PackagesController@manage'); // expects ?id=
// Legacy index path fallback to manage view to avoid 404s
$router->get('/admin/vendor-packages', 'PackagesController@manage'); // supports optional ?vendor_id=
$router->get('/admin/vendor-packages/', 'PackagesController@manage'); // trailing slash variant

// ===== Admin: Mail Settings & Logs =====
$router->get('/admin/settings/email', 'MailAdminController@settings');
$router->post('/admin/settings/email/save', 'MailAdminController@saveSettings');
$router->post('/admin/settings/email/test', 'MailAdminController@testSend');
$router->get('/admin/logs/emails', 'MailAdminController@logs');
$router->post('/admin/logs/emails/resend', 'MailAdminController@resend');

// ===== Mail Queue Processor (manual trigger or cron hitting this) =====
$router->post('/admin/mail/queue/process', 'MailQueueController@processBatch');

// ===== Webhooks for provider events =====
$router->post('/webhooks/ses', 'MailAdminController@webhookSes');
$router->post('/webhooks/sendgrid', 'MailAdminController@webhookSendGrid');

// Holiday Package Builder (separate page, not touching manage view)
// $router->get('/admin/vendor-packages/builder', 'PackagesController@builder'); // expects ?id=
// $router->get('/admin/vendor-packages/builder-preview', 'PackagesController@builderPreviewGet'); // debug-only GET
// $router->post('/admin/vendor-packages/builder-preview', 'PackagesController@builderPreview');

// ===== Admin: Holiday Packages (module removed) =====
// The HolidayPackagesController is not present. Routes disabled intentionally.
// $router->get('/admin/holidays', 'HolidayPackagesController@index');
// $router->get('/admin/holidays/create', 'HolidayPackagesController@create');
// $router->post('/admin/holidays/store', 'HolidayPackagesController@store');
// $router->get('/admin/holidays/manage', 'HolidayPackagesController@manage');
// $router->get('/admin/holidays/builder', 'HolidayPackagesController@builder');
// $router->get('/admin/holidays/builder-preview', 'HolidayPackagesController@builderPreviewGet');
// $router->post('/admin/holidays/builder-preview', 'HolidayPackagesController@builderPreview');
// $router->post('/admin/holidays/prices/store', 'HolidayPackagesController@priceStore');

// ===== Public/Agent API for booking UIs =====
$router->get('/api/vendor-packages', 'PackagesController@apiVendorPackages'); // ?vendor_id=
$router->get('/api/package-variants', 'PackagesController@apiPackageVariants'); // ?package_id=
$router->get('/api/variant-times', 'PackagesController@apiVariantTimes'); // ?variant_id= or ?package_id=
$router->post('/api/variant-price', 'PackagesController@apiVariantPrice'); // POST: variant_id, adult_qty, child_qty

// ===== B2B Agent JSON API (mobile UI support) =====
$router->get('/b2b/api/hotels/search', 'B2BApiController@hotelsSearch');
$router->get('/b2b/api/hotels/details', 'B2BApiController@hotelDetails');
$router->get('/b2b/api/hotels/quote', 'B2BApiController@hotelQuote');
$router->get('/b2b/api/wallet', 'B2BApiController@wallet');
$router->get('/b2b/api/security/pin-key', 'B2BApiController@txPinKey');
$router->get('/b2b/api/activities/search', 'B2BApiController@activitiesSearch');
$router->get('/b2b/api/activities/suggest', 'B2BApiController@activitiesSuggest');
$router->get('/b2b/api/activities/cities', 'B2BApiController@activitiesCities');
$router->get('/b2b/api/activities/details', 'B2BApiController@activitiesDetails');
$router->get('/b2b/api/taxi/quote', 'B2BApiController@taxiQuote');
$router->get('/b2b/api/taxi/search', 'B2BApiController@taxiSearch');
$router->get('/b2b/api/yachts/search', 'B2BApiController@yachtsSearch');
$router->post('/b2b/api/activities/book', 'B2BApiController@activitiesBook');
$router->post('/b2b/api/activities/book-multi', 'B2BApiController@activitiesBookMulti');
// Checkout (cart -> order -> pay)
$router->post('/b2b/api/checkout/create', 'B2BApiController@checkoutCreate');
$router->post('/b2b/api/checkout/pay-wallet', 'B2BApiController@checkoutPayWallet');
$router->post('/b2b/api/checkout/order-contact', 'B2BApiController@checkoutOrderContact');
// Checkout page and order fetch (B2B)
$router->get('/b2b/checkout', 'CheckoutController@index');
// Dedicated payment method selection page (B2B)
$router->get('/b2b/checkout/pay', 'CheckoutController@pay'); // expects ?id=&sig=
// Confirmation page after successful payment (B2B)
$router->get('/b2b/checkout/confirm', 'CheckoutController@confirm'); // expects ?id=&sig=
$router->get('/b2b/api/checkout/order', 'B2BApiController@checkoutOrder');

// [agent removed] Agent checkout and API aliases disabled (use /b2b/* counterparts)
// $router->get('/agent/checkout', 'CheckoutController@index');
// $router->get('/agent/checkout/pay', 'CheckoutController@pay'); // expects ?id=&sig=
// $router->get('/agent/checkout/confirm', 'CheckoutController@confirm'); // expects ?id=&sig=
// $router->get('/agent/api/checkout/order', 'B2BApiController@checkoutOrder');
// $router->post('/agent/api/checkout/order-contact', 'B2BApiController@checkoutOrderContact');
// $router->post('/agent/api/checkout/create', 'B2BApiController@checkoutCreate');
// $router->post('/agent/api/checkout/pay-wallet', 'B2BApiController@checkoutPayWallet');

// ===== B2B Agent Portal (Tailwind + DaisyUI, isolated) =====
$router->get('/b2b/agent/login', 'AgentPortalController@login');
$router->post('/b2b/agent/login', 'AgentPortalController@doLogin');
$router->get('/b2b/agent/logout', 'AgentPortalController@logout');

// Agent Password Reset Routes
$router->get('/b2b/agent/forgot-password', 'PasswordResetController@showForgotPasswordForm');
$router->post('/b2b/agent/forgot-password', 'PasswordResetController@sendResetLink');
$router->get('/b2b/agent/reset-password', 'PasswordResetController@showResetForm');
$router->post('/b2b/agent/reset-password', 'PasswordResetController@reset');
    // Agent Portal Routes
    $router->get('/b2b/agent', 'AgentPortalController@dashboard');
    $router->get('/b2b/agent/home', 'AgentPortalController@home');
    $router->get('/b2b/agent/search-fullscreen', 'AgentPortalController@searchFullscreen');
$router->get('/b2b/agent/hotels', 'AgentPortalController@hotels');
$router->get('/b2b/agent/activities', 'AgentPortalController@activities');
$router->get('/b2b/agent/activity', 'AgentPortalController@activity'); // expects ?id=
$router->get('/b2b/agent/cart', 'AgentPortalController@cart');
$router->post('/b2b/agent/cart/add', 'AgentPortalController@cartAdd');
$router->post('/b2b/agent/cart/remove', 'AgentPortalController@cartRemove');
$router->post('/b2b/agent/cart/clear', 'AgentPortalController@cartClear');
// Activity booking: customer details -> payment -> voucher
$router->get('/b2b/agent/activity/checkout', 'ActivityAgentController@checkout');
$router->post('/b2b/agent/activity/checkout', 'ActivityAgentController@checkout');
$router->get('/b2b/agent/activity/payment', 'ActivityAgentController@payment');
$router->post('/b2b/agent/activity/pay', 'ActivityAgentController@pay');
$router->get('/b2b/agent/activity/voucher', 'ActivityAgentController@voucher');
$router->get('/b2b/agent/activity/gateway-success', 'ActivityAgentController@gatewaySuccess');
// Alias for legacy/alternate success URL
$router->get('/b2b/agent/activity/success', 'ActivityAgentController@gatewaySuccess');
$router->get('/b2b/agent/taxi', 'AgentPortalController@taxi');
$router->get('/b2b/agent/taxi/detail', 'AgentPortalController@taxiDetail'); // ?id=
$router->get('/b2b/agent/taxi/book', 'AgentPortalController@taxiBook'); // ?id=
$router->get('/b2b/agent/taxi/payment', 'AgentPortalController@taxiPayment');
$router->post('/b2b/agent/taxi/payment', 'AgentPortalController@taxiPayment');
$router->post('/b2b/agent/taxi/pay', 'AgentPortalController@taxiPay');
$router->get('/b2b/agent/taxi/voucher', 'AgentPortalController@taxiVoucher'); // Default to boarding pass style
$router->get('/b2b/agent/yachts', 'AgentPortalController@yachts');
$router->get('/b2b/agent/yacht', 'AgentPortalController@yacht'); // expects ?id=
$router->post('/b2b/agent/yacht/book', 'AgentPortalController@yachtBook');
$router->get('/b2b/agent/yacht/confirm', 'AgentPortalController@yachtBookingConfirm');
$router->get('/b2b/agent/yacht/payment', 'AgentPortalController@yachtPayment');
$router->post('/b2b/agent/yacht/pay', 'AgentPortalController@yachtPay');
$router->get('/b2b/agent/yacht/voucher', 'AgentPortalController@yachtVoucher');
$router->post('/b2b/agent/yacht/cancel-request', 'AgentPortalController@yachtCancelRequest');
$router->post('/b2b/api/yacht/pay-gateway', 'PaymentsController@yachtPayGateway');
$router->post('/b2b/api/taxi/pay-gateway', 'PaymentsController@taxiPayGateway');
$router->get('/b2b/agent/taxi/bookings', 'AgentPortalController@taxiBookings');
$router->get('/b2b/agent/taxi/refunds', 'AgentPortalController@taxiRefunds');
$router->get('/b2b/agent/taxi/booking/view', 'AgentPortalController@taxiBookingView'); // ?id=
$router->get('/b2b/agent/hotel/booking/view', 'AgentPortalController@hotelBookingView'); // ?id=
$router->get('/b2b/agent/wallet/history', 'AgentPortalController@walletHistory');
$router->get('/b2b/agent/packages', 'AgentPortalController@packages');
$router->get('/b2b/agent/bookings', 'AgentPortalController@bookings');
$router->get('/b2b/agent/bookings/review', 'AgentPortalController@bookingReview');
$router->post('/b2b/agent/bookings/confirm', 'AgentPortalController@bookingConfirm');
// New flow: Prepare guest data then go to payment selection
$router->post('/b2b/agent/bookings/prepare', 'AgentPortalController@bookingPrepare');
$router->get('/b2b/agent/bookings/pay', 'AgentPortalController@bookingPay');
$router->get('/b2b/agent/refunds', 'AgentPortalController@refunds');
$router->get('/b2b/agent/refund', 'AgentPortalController@refund'); // alias -> redirects to /b2b/agent/refunds
$router->get('/b2b/agent/wallet', 'AgentPortalController@wallet');
$router->get('/b2b/agent/profile', 'AgentPortalController@profile');
// Agent: Wallet Deposit Requests (no dynamic segments; use query/POST)
$router->get('/b2b/agent/wallet/deposit', 'AgentWalletDepositsController@new');
$router->post('/b2b/agent/wallet/deposit', 'AgentWalletDepositsController@create');
$router->get('/b2b/agent/wallet/deposit/show', 'AgentWalletDepositsController@show'); // ?id=
$router->post('/b2b/agent/wallet/deposit/proof', 'AgentWalletDepositsController@uploadProof');
$router->get('/b2b/agent/wallet/deposit/history', 'AgentWalletDepositsController@history');
// Agent Support Center (handled by SupportController)
// Wallet payment for booking confirmation (agent portal)
$router->post('/b2b/agent/pay/wallet', 'AgentPortalController@bookingPayWallet');
// Stripe card payment for booking confirmation (agent portal)
$router->post('/b2b/agent/bookings/pay/stripe', 'AgentPortalController@bookingPayStripe');
// Post-payment confirmation and voucher
$router->get('/b2b/agent/bookings/confirmation', 'AgentPortalController@bookingConfirmation'); // expects ?pi_id=
$router->get('/b2b/agent/bookings/voucher', 'AgentPortalController@bookingVoucher'); // expects ?code= or ?id=
// Hotel booking cancellation request (agent portal)
$router->post('/b2b/agent/bookings/cancel-request', 'AgentPortalController@bookingCancelRequest');

// Webhooks
$router->post('/webhooks/stripe', 'WebhookController@stripe');
// Detail pages
$router->get('/b2b/agent/hotel', 'AgentPortalController@hotel'); // expects ?id=
$router->post('/b2b/agent/hotel/precheck', 'AgentPortalController@hotelPrecheck');
// Search endpoints from dashboard tabs -> redirect to category pages with params
$router->get('/b2b/agent/search/activities', 'AgentPortalController@searchActivities');
$router->get('/b2b/agent/search/taxi', 'AgentPortalController@searchTaxi');
$router->get('/b2b/agent/search/hotels', 'AgentPortalController@searchHotels');
$router->get('/b2b/agent/search/yachts', 'AgentPortalController@searchYachts');
$router->get('/b2b/agent/search/packages', 'AgentPortalController@searchPackages');

// Agent module-specific shortcuts (filter to unified pages)
$router->get('/b2b/agent/activities/bookings', 'AgentPortalController@activitiesBookings');
$router->get('/b2b/agent/activities/refunds', 'AgentPortalController@activitiesRefunds');
$router->get('/b2b/agent/hotels/bookings', 'AgentPortalController@hotelsBookings');
$router->get('/b2b/agent/hotels/refunds', 'AgentPortalController@hotelsRefunds');
$router->get('/b2b/agent/yachts/bookings', 'AgentPortalController@yachtsBookings');
$router->get('/b2b/agent/yachts/refunds', 'AgentPortalController@yachtsRefunds');

// Agent booking detail views (Activity/Yacht)
$router->get('/b2b/agent/activity/booking/view', 'AgentPortalController@activityBookingView'); // ?id=
$router->get('/b2b/agent/yacht/booking/view', 'AgentPortalController@yachtBookingView'); // ?id=

// --- Legacy aliases (for old links / different base paths) ---
$router->get('/login/agent', 'AgentPortalController@login');
$router->post('/login/agent', 'AgentPortalController@doLogin');
$router->get('/agent/login', 'AgentPortalController@login');
$router->post('/agent/login', 'AgentPortalController@doLogin');
$router->get('/agent/logout', 'AgentPortalController@logout');
$router->get('/agent', 'AgentPortalController@dashboard');
$router->get('/agent/hotels', 'AgentPortalController@hotels');
$router->get('/agent/activities', 'AgentPortalController@activities');
$router->get('/agent/taxi', 'AgentPortalController@taxi');
$router->get('/agent/yachts', 'AgentPortalController@yachts');
$router->get('/agent/taxi/bookings', 'AgentPortalController@taxiBookings');
$router->get('/agent/packages', 'AgentPortalController@packages');
$router->get('/agent/bookings', 'AgentPortalController@bookings');
$router->get('/agent/wallet', 'AgentPortalController@wallet');
$router->get('/agent/profile', 'AgentPortalController@profile');
// Legacy alias for wallet pay (if older links submit under /agent)
$router->post('/agent/pay/wallet', 'AgentPortalController@bookingPayWallet');
// Legacy detail
$router->get('/agent/hotel', 'AgentPortalController@hotel'); // expects ?id=
// Legacy aliases for search
$router->get('/agent/search/activities', 'AgentPortalController@searchActivities');
$router->get('/agent/search/taxi', 'AgentPortalController@searchTaxi');
$router->get('/agent/search/hotels', 'AgentPortalController@searchHotels');
$router->get('/agent/search/yachts', 'AgentPortalController@searchYachts');
$router->get('/agent/search/packages', 'AgentPortalController@searchPackages');

// ===== Agent Self-Registration + Email OTP =====
$router->get('/agent/register', 'AgentAuthController@register');
$router->post('/agent/register', 'AgentAuthController@registerPost');
$router->get('/agent/verify-email', 'AgentAuthController@verifyEmail');
$router->post('/agent/verify-email', 'AgentAuthController@verifyEmailPost');
$router->post('/agent/resend-otp', 'AgentAuthController@resendOtp');

// ===== Agent KYC =====
$router->get('/agent/kyc', 'AgentKycController@index');
$router->post('/agent/kyc/submit', 'AgentKycController@submit');
$router->get('/agent/kyc/status', 'AgentKycController@status');
// Alias for JSON check
$router->get('/agent/kyc/check', 'AgentKycController@check');

// Aliases under /b2b/agent for consistency with other agent routes
$router->get('/b2b/agent/kyc', 'AgentKycController@index');
$router->post('/b2b/agent/kyc/submit', 'AgentKycController@submit');
$router->get('/b2b/agent/kyc/status', 'AgentKycController@status');
// Lightweight JSON check for KYC status (used by header to gate navigation)
$router->get('/b2b/agent/kyc/check', 'AgentKycController@check');

// $router->get('/agent/api/wallet', 'B2BApiController@wallet');
// $router->get('/agent/api/security/pin-key', 'B2BApiController@txPinKey');

// ===== Payments: Stripe Checkout Session + Webhook =====
$router->post('/b2b/api/checkout/pay-gateway', 'PaymentsController@payGateway');
$router->post('/agent/api/checkout/pay-gateway', 'PaymentsController@payGateway');
$router->post('/webhook/stripe', 'PaymentsController@stripeWebhook');

// ===== Admin Top Menu: Tools =====
$router->get('/admin/tools/country-currency', 'ToolsController@countryCurrency');
$router->post('/admin/tools/country-currency/unlock', 'ToolsController@unlockCountryCurrency');
$router->post('/admin/tools/country-currency/country', 'ToolsController@storeCountry');
$router->post('/admin/tools/country-currency/country/update', 'ToolsController@updateCountry');
$router->post('/admin/tools/country-currency/country/delete', 'ToolsController@deleteCountry');
$router->post('/admin/tools/country-currency/currency', 'ToolsController@storeCurrency');
$router->post('/admin/tools/country-currency/location', 'ToolsController@storeLocation');
$router->post('/admin/tools/country-currency/location/delete', 'ToolsController@deleteLocation');
// Email templates preview
$router->get('/admin/tools/email-templates', 'ToolsController@emailTemplates');
$router->post('/admin/tools/email-templates/unlock', 'ToolsController@emailTemplatesUnlock');
$router->get('/admin/tools/email-templates/preview', 'ToolsController@emailTemplatesPreview');
// Editor API
$router->get('/admin/tools/email-templates/file', 'ToolsController@emailTemplatesFile');
$router->post('/admin/tools/email-templates/file', 'ToolsController@emailTemplatesFileSave');
// Test send
$router->post('/admin/tools/email-templates/test-send', 'ToolsController@emailTemplatesTestSend');

// Payment Gateways tool
$router->get('/admin/tools/payment-gateways', 'ToolsController@paymentGateways');
$router->post('/admin/tools/payment-gateways/toggle', 'ToolsController@paymentGatewayToggle');
$router->post('/admin/tools/payment-gateways/save', 'ToolsController@paymentGatewaySave');

// Admin: Payments list
$router->get('/admin/payments', 'AdminController@payments');

// Admin: Wallet Deposit Requests (no dynamic segments; use query/POST id)
$router->get('/admin/wallet/deposits', 'AdminWalletDepositsController@index');
$router->get('/admin/wallet/deposits/view', 'AdminWalletDepositsController@show'); // ?id=
$router->post('/admin/wallet/deposits/assign', 'AdminWalletDepositsController@assign');
$router->post('/admin/wallet/deposits/approve', 'AdminWalletDepositsController@approve');
$router->post('/admin/wallet/deposits/reject', 'AdminWalletDepositsController@reject');
$router->get('/admin/wallet/deposits/export.csv', 'AdminWalletDepositsController@exportCsv');

// Admin: Order view (read-only)
$router->get('/admin/orders/view', 'AdminController@orderView'); // expects ?id=

// Admin: Booking detail views
$router->get('/admin/booking/hotel/view', 'AdminController@bookingHotelView'); // expects ?id=
// Admin: Taxi bookings
$router->get('/admin/booking/taxi', 'AdminController@bookingTaxi');
$router->get('/admin/booking/taxi/view', 'AdminController@bookingTaxiView');
$router->get('/admin/booking/taxi/edit', 'AdminController@bookingTaxiEdit'); // expects ?id=
$router->post('/admin/booking/taxi/update', 'AdminController@bookingTaxiUpdate'); // expects ?id=
$router->post('/admin/booking/taxi/cancel', 'AdminController@bookingTaxiCancel');
$router->post('/admin/booking/taxi/refund', 'AdminController@bookingTaxiRefund');
$router->post('/admin/booking/taxi/refund-gateway', 'AdminController@bookingTaxiRefundGateway');

// ===== Admin: Vendor Payouts =====
$router->get('/admin/vendor-payouts', 'AdminController@vendorPayouts');
$router->post('/admin/vendor-payouts/mark-paid', 'AdminController@vendorPayoutsMarkPaid');
$router->post('/admin/vendor-payouts/mark-paid-vendor', 'AdminController@vendorPayoutsMarkPaidVendor');

// One-time DB patch helpers
$router->get('/admin/tools/db/patch-hotels-active', 'ToolsController@dbPatchHotelsActive');
$router->get('/admin/tools/db/patch-hotels-audience-flags', 'ToolsController@dbPatchHotelsAudienceFlags');
$router->get('/admin/tools/db/patch-vendor-packages', 'ToolsController@dbPatchVendorPackages');

// ===== Admin Settings: KYC =====
$router->get('/admin/settings/kyc', 'SettingsController@kyc');
$router->post('/admin/settings/kyc/unlock', 'SettingsController@kycUnlock');
$router->post('/admin/settings/kyc', 'SettingsController@kycUpdate');

// ===== Vendor Portal (Bootstrap) =====
$router->get('/vendor/login', 'VendorAuthController@login');
$router->post('/vendor/login', 'VendorAuthController@loginPost');
$router->post('/login/vendor', 'VendorAuthController@loginPost'); // Add this line for /login/vendor route
$router->get('/vendor/logout', 'VendorAuthController@logout');

$router->get('/vendor/dashboard', 'VendorPortalController@dashboard');
$router->get('/vendor/jobs', 'VendorPortalController@jobs');
$router->get('/vendor/job/view', 'VendorPortalController@jobView'); // expects ?id=
$router->post('/vendor/job/assign-driver', 'VendorPortalController@assignDriver');
$router->post('/vendor/job/status', 'VendorPortalController@updateStatus');
$router->post('/vendor/job/upload-pickup-photo', 'VendorPortalController@uploadPickupPhoto');

// Signed accept/reject links from email
$router->get('/vendor/dispatch/accept', 'VendorDispatchController@accept');
$router->get('/vendor/dispatch/reject', 'VendorDispatchController@reject');
$router->post('/vendor/dispatch/accept', 'VendorDispatchController@accept');
$router->post('/vendor/dispatch/reject', 'VendorDispatchController@reject');

// ===== Admin Settings: SMTP =====
$router->get('/admin/settings/smtp', 'SettingsController@smtp');
$router->post('/admin/settings/smtp/unlock', 'SettingsController@smtpUnlock');
$router->post('/admin/settings/smtp', 'SettingsController@smtpUpdate');
$router->post('/admin/settings/smtp/test-api', 'SettingsController@smtpTestApi');
// Direct Elastic API raw test
$router->post('/admin/settings/smtp/test-elastic-direct', 'SettingsController@smtpTestElasticDirect');

// ===== Admin: WhatsApp Messaging =====
$router->get('/admin/settings/whatsapp', 'WhatsAppAdminController@settings');
$router->post('/admin/settings/whatsapp', 'WhatsAppAdminController@save');
$router->post('/admin/settings/whatsapp/test', 'WhatsAppAdminController@test');
$router->get('/admin/logs/whatsapp', 'WhatsAppAdminController@logs');
$router->post('/admin/logs/whatsapp/resend', 'WhatsAppAdminController@resend');
$router->post('/admin/whatsapp/queue/process', 'WhatsAppQueueController@processBatch');

// ===== Agent: Support =====
$router->get('/b2b/agent/support', 'SupportController@agentSupport');
$router->get('/b2b/agent/support/view', 'SupportController@agentView');
$router->post('/b2b/agent/support', 'SupportController@agentSupportStore');
$router->post('/b2b/agent/support/reply', 'SupportController@agentReply');
$router->post('/b2b/agent/support/status', 'SupportController@agentStatus');
$router->get('/b2b/agent/support/replies', 'SupportController@agentRepliesJson');

// ===== Admin: Support =====
$router->get('/admin/support', 'AdminController@supportIndex');
$router->get('/admin/support/view', 'AdminController@supportView'); // ?id=
$router->post('/admin/support/reply', 'AdminController@supportReply');
$router->post('/admin/support/status', 'AdminController@supportStatus');
$router->get('/admin/support/replies', 'SupportController@adminRepliesJson');

// Admin: Security - Unlock agent login
$router->get('/admin/security/agent/unlock', 'AdminController@agentUnlockForm');
$router->post('/admin/security/agent/unlock', 'AdminController@agentUnlock');
$router->post('/admin/security/ip-throttle/clear', 'AdminController@ipThrottleClear');

// ===== Admin: Media Upload =====
$router->get('/admin/media', 'MediaController@index');
$router->post('/admin/media/upload', 'MediaController@upload');

// ===== Admin: Vendors (create login credentials)
$router->post('/admin/vendors/create-login', 'VendorsController@createLogin');
$router->post('/admin/vendors/reset-login', 'VendorsController@resetLogin');

// ===== Admin: Airports (master data for taxi)
$router->get('/admin/airports', 'AirportsAdminController@index');
$router->post('/admin/airports/unlock', 'AirportsAdminController@unlock');
$router->get('/admin/airports/create', 'AirportsAdminController@create');
$router->post('/admin/airports/store', 'AirportsAdminController@store');
$router->get('/admin/airports/edit', 'AirportsAdminController@edit'); // ?id=
$router->post('/admin/airports/update', 'AirportsAdminController@update');
$router->post('/admin/airports/delete', 'AirportsAdminController@delete');

// ===== Admin: Taxi Itineraries
$router->get('/admin/taxi/itineraries', 'TaxiItinerariesAdminController@index');
$router->post('/admin/taxi/itineraries/unlock', 'TaxiItinerariesAdminController@unlock');
$router->get('/admin/taxi/itineraries/create', 'TaxiItinerariesAdminController@create');
$router->post('/admin/taxi/itineraries/store', 'TaxiItinerariesAdminController@store');
$router->get('/admin/taxi/itineraries/edit', 'TaxiItinerariesAdminController@edit'); // ?id=
$router->post('/admin/taxi/itineraries/update', 'TaxiItinerariesAdminController@update');
$router->post('/admin/taxi/itineraries/delete', 'TaxiItinerariesAdminController@delete');

// ===== Admin Top Menu: Categories =====
$router->get('/admin/categories/create', 'CategoriesController@create');
$router->post('/admin/categories/unlock', 'CategoriesController@unlock');
$router->post('/admin/categories/store', 'CategoriesController@store');
$router->post('/admin/categories/update', 'CategoriesController@update');
$router->post('/admin/categories/delete', 'CategoriesController@delete');

// ===== Admin: Taxis Management =====
$router->get('/admin/taxis', 'TaxiAdminController@index');
$router->post('/admin/taxis/unlock', 'TaxiAdminController@unlock');
$router->get('/admin/taxis/create', 'TaxiAdminController@create');
$router->post('/admin/taxis/store', 'TaxiAdminController@store');
$router->get('/admin/taxis/edit', 'TaxiAdminController@edit');
$router->get('/admin/taxis/view', 'TaxiAdminController@show');
$router->get('/admin/taxis/show', 'TaxiAdminController@show');
$router->post('/admin/taxis/update', 'TaxiAdminController@update');
$router->post('/admin/taxis/enable', 'TaxiAdminController@enable');
$router->post('/admin/taxis/disable', 'TaxiAdminController@disable');
$router->post('/admin/taxis/delete', 'TaxiAdminController@delete');

// ===== Admin: Hotels Management =====
$router->get('/admin/hotels', 'HotelsAdminController@index');
$router->post('/admin/hotels/unlock', 'HotelsAdminController@unlock');
$router->get('/admin/hotels/create', 'HotelsAdminController@create');
$router->post('/admin/hotels/store', 'HotelsAdminController@store');
$router->get('/admin/hotels/edit', 'HotelsAdminController@edit');
$router->post('/admin/hotels/update', 'HotelsAdminController@update');
$router->post('/admin/hotels/enable', 'HotelsAdminController@enable');
$router->post('/admin/hotels/disable', 'HotelsAdminController@disable');
$router->post('/admin/hotels/delete', 'HotelsAdminController@delete');
$router->post('/admin/hotels/toggle-flag', 'HotelsAdminController@toggleFlag');
$router->get('/admin/hotels/flags', 'HotelsAdminController@flags'); // ?id=

// ---- Hotels: Rooms CRUD
$router->post('/admin/hotels/rooms/store', 'HotelsAdminController@roomStore');
$router->post('/admin/hotels/rooms/update', 'HotelsAdminController@roomUpdate');
$router->post('/admin/hotels/rooms/delete', 'HotelsAdminController@roomDelete');

// ---- Hotels: Rate Plans CRUD
$router->post('/admin/hotels/rateplans/store', 'HotelsAdminController@ratePlanStore');
$router->post('/admin/hotels/rateplans/update', 'HotelsAdminController@ratePlanUpdate');
$router->post('/admin/hotels/rateplans/delete', 'HotelsAdminController@ratePlanDelete');

// ---- Hotels: Calendar
$router->post('/admin/hotels/calendar/save', 'HotelsAdminController@calendarSave');

// ---- Hotels: Policies
$router->post('/admin/hotels/policies/save', 'HotelsAdminController@policySave');

// ---- Hotels: Images
$router->post('/admin/hotels/images/upload', 'HotelsAdminController@imageUpload');
$router->post('/admin/hotels/images/delete', 'HotelsAdminController@imageDelete');

// ===== Admin: Yachts Management =====
$router->get('/admin/yachts', 'YachtsAdminController@index');
$router->post('/admin/yachts/unlock', 'YachtsAdminController@unlock');
$router->get('/admin/yachts/create', 'YachtsAdminController@create');
$router->post('/admin/yachts/store', 'YachtsAdminController@store');
$router->get('/admin/yachts/edit', 'YachtsAdminController@edit'); // ?id=
$router->post('/admin/yachts/update', 'YachtsAdminController@update');
$router->post('/admin/yachts/enable', 'YachtsAdminController@enable');
$router->post('/admin/yachts/disable', 'YachtsAdminController@disable');
$router->post('/admin/yachts/delete', 'YachtsAdminController@delete');

// ===== Admin Top Menu: Management =====
$router->get('/admin/management/agents/create', 'ManagementController@agentCreate');
$router->get('/admin/management/agents', 'ManagementController@agentIndex');
$router->get('/admin/management/agents/view', 'ManagementController@agentView'); // ?id=
$router->post('/admin/management/agents/toggle_status', 'ManagementController@agentToggleStatus');
$router->post('/admin/management/agents/create_wallet', 'ManagementController@createWallet');
// Agent minimal settings and password reset
$router->get('/admin/management/agents/settings', 'ManagementController@agentSettings'); // ?id=
$router->post('/admin/management/agents/settings', 'ManagementController@agentSettingsSave');
$router->post('/admin/management/agents/settings/view_pin', 'ManagementController@agentSettingsViewPin');
$router->post('/admin/management/agents/settings/api_generate', 'ManagementController@agentGenerateApiCredentials');
$router->post('/admin/management/agents/reset_password', 'ManagementController@agentResetPassword');
$router->get('/admin/management/partners/create', 'ManagementController@partnerCreate');
$router->get('/admin/management/partners', 'ManagementController@partnerIndex');
$router->get('/admin/management/partners/view', 'ManagementController@partnerView'); // ?id=
$router->get('/admin/management/partners/wallet', 'ManagementController@partnerWallet'); // ?id=
$router->get('/admin/management/partners/agents', 'ManagementController@partnerAgents'); // ?id=
$router->get('/admin/management/partners/edit', 'ManagementController@partnerEdit'); // ?id=
$router->post('/admin/management/partners/impersonate', 'ManagementController@partnerImpersonate');
$router->get('/auth/impersonation/stop', 'ManagementController@stopImpersonation');
$router->post('/admin/management/partners/reset_password', 'ManagementController@partnerResetPassword');
$router->post('/admin/management/partners/update', 'ManagementController@partnerUpdate');
$router->post('/admin/management/partners/toggle_status', 'ManagementController@partnerToggleStatus');
$router->post('/admin/management/partners/store', 'ManagementController@partnerStore');
// Partner granular settings (modal)
$router->get('/admin/management/partners/settings', 'ManagementController@partnerSettings'); // expects ?id=
$router->post('/admin/management/partners/settings', 'ManagementController@partnerSettingsSave');
$router->post('/admin/management/partners/settings/view_pin', 'ManagementController@partnerSettingsViewPin');
$router->get('/admin/management/employees/create', 'ManagementController@employeeCreate');
$router->get('/admin/management/customers/create', 'ManagementController@customerCreate');

// ===== Admin: KYC Reviews =====
$router->get('/admin/kyc', 'KycController@index');
$router->get('/admin/kyc/view', 'KycController@show'); // expects ?id=<kyc_id>
$router->post('/admin/kyc/approve', 'KycController@approve');
$router->post('/admin/kyc/reject', 'KycController@reject');
// Secure file streaming (encrypted-at-rest)
$router->get('/admin/kyc/file', 'KycController@file'); // ?id=<kyc_id>&side=front|back
$router->get('/admin/kyc/doc', 'KycController@doc');   // ?id=<business_doc_id>

