<?php
namespace App\Policies;

class RBAC
{
    // Matrix: role => permissions (module.action)
    public static function matrix(): array
    {
        return [
            'Admin' => ['*'],
            'Employee' => [
                'users.view','users.edit','users.create',
                'wallet.view','wallet.approve','wallet.manual',
                'booking.view','booking.edit','booking.cancel',
                'support.view','support.reply',
            ],
            'Channel Partner' => [
                'dashboard.view','agents.view','commissions.view','wallet.view'
            ],
            'B2B Agent' => [
                'catalog.view','booking.create','booking.view','wallet.view','wallet.topup','ticket.create','ticket.view'
            ],
            'Vendor' => [
                'vendor.dashboard','vendor.bookings.view','vendor.inventory.edit'
            ],
        ];
    }

    public static function allows(string $role, string $permission): bool
    {
        $mx = self::matrix();
        $perms = $mx[$role] ?? [];
        return in_array('*', $perms, true) || in_array($permission, $perms, true);
    }
}
