<?php
namespace App\Middleware;

use App\Policies\RBAC;

class RoleGuard
{
    public static function requirePermission(string $permission): void
    {
        $role = $_SESSION['user']['role'] ?? null;
        if (!$role || !RBAC::allows($role, $permission)) {
            http_response_code(403);
            echo 'Forbidden';
            exit;
        }
    }
}
