<?php
namespace App\Core\WhatsApp;

class Message
{
    public string $to;
    public string $text;
    public ?string $from;
    public string $type; // 'text' | 'template' | 'quick_reply'
    public array $meta;  // extra fields per provider/type

    public function __construct(string $to, string $text, ?string $from = null, string $type = 'text', array $meta = [])
    {
        $this->to = $to;
        $this->text = $text;
        $this->from = $from;
        $this->type = $type;
        $this->meta = $meta;
    }
}

class SendResult
{
    public bool $ok;
    public ?string $messageId;
    public ?string $error;

    public function __construct(bool $ok, ?string $messageId = null, ?string $error = null)
    {
        $this->ok = $ok;
        $this->messageId = $messageId;
        $this->error = $error;
    }
}

interface ProviderInterface
{
    public function name(): string;
    public function send(Message $msg): SendResult;
}
