<?php
namespace App\Core;

class View
{
    public function render(string $template, array $data = []): void
    {
        $templatePath = dirname(__DIR__) . '/Views/' . $template . '.php';
        if (!file_exists($templatePath)) {
            http_response_code(500);
            echo 'View not found: ' . htmlspecialchars($template);
            return;
        }
        // Make data variables available to layout and template
        if (!empty($data)) {
            extract($data, EXTR_OVERWRITE);
        }
        // Agent Portal views (Tailwind + DaisyUI) ship with their own header/footer partials
        // and must NOT be wrapped by the global Bootstrap layout.
        $isAgentView = (strpos($template, 'agent/') === 0);
        if ($isAgentView) {
            include $templatePath;
            return;
        }
        // Default: use the main Bootstrap layout
        include dirname(__DIR__) . '/Views/layouts/main.php';
    }
}
