<?php
namespace App\Core;

class Upload
{
    public static function image(array $file, string $destDir, array $allowed = ['image/jpeg','image/png','image/webp'], int $maxSize = 5242880): array
    {
        if (($file['error'] ?? UPLOAD_ERR_NO_FILE) !== UPLOAD_ERR_OK) {
            return ['ok' => false, 'error' => 'Upload error'];
        }
        if ($file['size'] > $maxSize) return ['ok' => false, 'error' => 'File too large'];
        $finfo = finfo_open(FILEINFO_MIME_TYPE);
        $mime = trim((string)finfo_file($finfo, $file['tmp_name']));
        finfo_close($finfo);
        if (!in_array($mime, $allowed, true)) return ['ok' => false, 'error' => 'Invalid mime'];
        if (!is_dir($destDir)) @mkdir($destDir, 0775, true);
        $ext = match($mime){'image/jpeg'=>'jpg','image/png'=>'png','image/webp'=>'webp',default=>'dat'};
        $name = bin2hex(random_bytes(8)) . '.' . $ext;
        $path = rtrim($destDir,'/\\') . DIRECTORY_SEPARATOR . $name;
        if (!move_uploaded_file($file['tmp_name'], $path)) return ['ok' => false, 'error' => 'Save failed'];
        return ['ok' => true, 'path' => $path, 'name' => $name, 'mime' => $mime];
    }
}
