<?php
namespace App\Core\Menu;

class MenuItem
{
    public string $label;
    public ?string $url;
    public ?string $icon;
    /** @var MenuItem[] */
    public array $children;

    public function __construct(string $label, ?string $url = null, ?string $icon = null, array $children = [])
    {
        $this->label = $label;
        $this->url = $url;
        $this->icon = $icon;
        $this->children = $children;
    }

    public static function link(string $label, string $url, ?string $icon = null): self
    {
        return new self($label, $url, $icon, []);
    }

    public static function group(string $label, array $children, ?string $icon = null): self
    {
        return new self($label, null, $icon, $children);
    }
}
