<?php
namespace App\Core\Mail;

class Template
{
    /**
     * Render an email by injecting a module/content block into a base HTML layout
     * and replacing {{placeholders}} from $data. Safe: basic {{var}} replacement.
     */
    public static function render(string $baseHtml, string $blockHtml, array $data): string
    {
        $html = str_replace('<!-- MODULE_BLOCK -->', $blockHtml, $baseHtml);
        foreach ($data as $k => $v) {
            $html = str_replace('{{'.$k.'}}', htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'), $html);
        }
        return $html;
    }
}
