<?php
namespace App\Core\Mail\Providers;

use App\Core\Mail\ProviderInterface; 
use App\Core\Mail\Envelope; 
use App\Core\Mail\SendResult; 
use App\Core\Mail\Mailer;

class SmtpProvider implements ProviderInterface
{
    private Mailer $mailer;
    private array $profile;
    private string $label;

    public function __construct(array $config, string $label = 'smtp')
    {
        $this->mailer = new Mailer($config);
        $this->profile = $config;
        $this->label = $label; // 'smtp' or 'ses' if using SES SMTP
    }

    public function send(Envelope $env): SendResult
    {
        $from = [ 'address' => $env->fromEmail ?? ($this->profile['from']['address'] ?? 'noreply@example.com'),
                  'name' => $env->fromName ?? ($this->profile['from']['name'] ?? '') ];
        $cfg = $this->profile;
        $cfg['from'] = $from;
        $mailer = new Mailer($cfg);
        $res = $mailer->sendHtml($env->to, $env->subject, $env->html, $env->altText);
        return new SendResult((bool)$res['ok'], (string)($res['message'] ?? ''), null, 0);
    }

    public function name(): string { return $this->label; }
}
