<?php
namespace App\Core;

class Auth
{
    public static function checkRole(array $roles): void
    {
        $user = $_SESSION['user'] ?? null;
        if (!$user || !in_array($user['role'], $roles, true)) {
            // If AJAX, return JSON 401 to avoid HTML in XHR responses
            $accept = (string)($_SERVER['HTTP_ACCEPT'] ?? '');
            $xhr = (string)($_SERVER['HTTP_X_REQUESTED_WITH'] ?? '');
            $isAjax = (stripos($accept, 'application/json') !== false) || (strcasecmp($xhr, 'XMLHttpRequest') === 0);
            if ($isAjax) {
                http_response_code(401);
                header('Content-Type: application/json');
                echo json_encode(['error' => 'Unauthorized']);
                exit;
            }
            header('Location: ' . rtrim(\APP_URL, '/') . '/login');
            exit;
        }
    }

    // Backward-compat alias used by controllers
    public static function requireRole(array $roles): void
    {
        self::checkRole($roles);
    }
}
