<?php
namespace App\Controllers;

use App\Core\Auth;
use App\Core\Controller;
use App\Core\Security;
use App\Core\WhatsApp\WhatsAppService;
use PDO;

class WhatsAppQueueController extends Controller
{
    public function processBatch(): void
    {
        Auth::requireRole(['Admin']);
        Security::requireCsrf();
        $limit = max(1, min(100, (int)($_POST['limit'] ?? 20)));
        $st = $this->pdo->prepare("SELECT * FROM whatsapp_queue WHERE status='pending' ORDER BY created_at ASC LIMIT :lim");
        $st->bindValue(':lim', $limit, PDO::PARAM_INT);
        $st->execute();
        $rows = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];
        $svc = new WhatsAppService($this->pdo);
        $sent = 0; $failed = 0;
        foreach ($rows as $row) {
            $res = $svc->sendQueueItem($row);
            if (!empty($res['ok'])) $sent++; else $failed++;
        }
        $_SESSION['flash'] = "Queue processed: sent={$sent}, failed={$failed}.";
        $this->redirect('/admin/settings/whatsapp');
    }
}
