<?php
namespace App\Controllers;

use App\Core\Controller;

class VerifyController extends Controller
{
    // GET /verify or /verify?code=...
    public function index(): void
    {
        $code = trim((string)($_GET['code'] ?? ''));
        $code = preg_replace('/[^A-Za-z0-9\-]/', '', $code);

        $result = null; // ['type' => 'taxi|hotel|activity', 'data' => array]

        if ($code !== '') {
            // Try to infer type by prefix
            $prefix = strtoupper(substr($code, 0, 3));
            $tryOrder = [];
            if ($prefix === 'TAX') { $tryOrder = ['taxi','hotel','activity']; }
            elseif ($prefix === 'HOT') { $tryOrder = ['hotel','taxi','activity']; }
            elseif ($prefix === 'ACT') { $tryOrder = ['activity','taxi','hotel']; }
            else { $tryOrder = ['taxi','hotel','activity']; }

            foreach ($tryOrder as $type) {
                try {
                    if ($type === 'taxi') {
                        $st = $this->pdo->prepare('SELECT b.id, b.booking_code, b.status, b.payment_status, b.pax, b.trip_date, b.from_text, b.to_text, t.vehicle_type, t.name AS ride_name
                                                    FROM taxi_bookings b JOIN taxis t ON t.id = b.taxi_id
                                                    WHERE b.booking_code = :code LIMIT 1');
                        $st->execute([':code' => $code]);
                        $row = $st->fetch(\PDO::FETCH_ASSOC) ?: null;
                        if ($row) { $result = ['type' => 'taxi', 'data' => $row]; break; }
                    } elseif ($type === 'hotel') {
                        // Best-effort: adjust table/columns if different in your schema
                        $st = $this->pdo->prepare('SELECT id, booking_code, status, payment_status, guest_name, hotel_name, checkin_date, checkout_date
                                                    FROM hotel_bookings WHERE booking_code = :code LIMIT 1');
                        $st->execute([':code' => $code]);
                        $row = $st->fetch(\PDO::FETCH_ASSOC) ?: null;
                        if ($row) { $result = ['type' => 'hotel', 'data' => $row]; break; }
                    } elseif ($type === 'activity') {
                        // Best-effort: adjust table/columns if different in your schema
                        $st = $this->pdo->prepare('SELECT id, booking_code, status, payment_status, customer_name, activity_name, travel_date, pax
                                                    FROM activity_bookings WHERE booking_code = :code LIMIT 1');
                        $st->execute([':code' => $code]);
                        $row = $st->fetch(\PDO::FETCH_ASSOC) ?: null;
                        if ($row) { $result = ['type' => 'activity', 'data' => $row]; break; }
                    }
                } catch (\Throwable $_) {
                    // Ignore and continue trying other types
                }
            }
        }

        $this->view('verify', [
            'title' => 'Booking Verification',
            'code' => $code,
            'result' => $result,
        ]);
    }
}
