<?php
namespace App\Controllers;

use App\Core\Controller;

class VendorDispatchController extends Controller
{
    private function findDispatch(string $token): ?array
    {
        if ($token === '') return null;
        try {
            $st = $this->pdo->prepare('SELECT d.*, b.vendor_id AS booking_vendor_id FROM taxi_vendor_dispatch d JOIN taxi_bookings b ON b.id=d.booking_id WHERE d.invite_token = :t LIMIT 1');
            $st->execute([':t' => $token]);
            $row = $st->fetch(\PDO::FETCH_ASSOC) ?: null;
            return $row ?: null;
        } catch (\Throwable $e) { return null; }
    }

    // POST /vendor/dispatch/accept
    public function accept(): void
    {
        $token = trim((string)($_POST['token'] ?? ($_GET['token'] ?? '')));
        $d = $this->findDispatch($token);
        if (!$d) { http_response_code(400); echo 'Invalid or expired link'; return; }
        if ((string)($d['status'] ?? '') !== 'pending') { http_response_code(200); echo 'Already processed'; return; }
        $exp = strtotime((string)$d['expires_at']);
        if ($exp && $exp < time()) { $this->markExpired((int)$d['id']); echo 'Link expired'; return; }
        try {
            $this->pdo->beginTransaction();
            // Mark dispatch
            $ud = $this->pdo->prepare("UPDATE taxi_vendor_dispatch SET status='accepted', accepted_at=NOW() WHERE id=:id");
            $ud->execute([':id'=>(int)$d['id']]);
            // Set booking vendor + timestamps
            $ub = $this->pdo->prepare('UPDATE taxi_bookings SET vendor_id=:vid, vendor_assigned_at=IFNULL(vendor_assigned_at, NOW()), vendor_accepted_at=NOW() WHERE id=:bid');
            $ub->execute([':vid'=>(int)$d['vendor_id'], ':bid'=>(int)$d['booking_id']]);
            // Event
            $ev = $this->pdo->prepare('INSERT INTO taxi_booking_events (booking_id, user_id, event_type, note, data_json, created_at) VALUES (:bid, 0, \'vendor_accepted\', :note, :data, NOW())');
            $ev->execute([':bid'=>(int)$d['booking_id'], ':note'=>'Vendor accepted invitation', ':data'=>json_encode(['vendor_id'=>(int)$d['vendor_id'], 'ip'=>($_SERVER['REMOTE_ADDR'] ?? '')])]);
            $this->pdo->commit();
        } catch (\Throwable $e) { $this->pdo->rollBack(); }
        header('Content-Type: text/html; charset=UTF-8');
        echo '<!DOCTYPE html><html><body style="font-family:system-ui,Segoe UI,Arial,sans-serif;padding:24px;">'
            .'<h3>Invitation Accepted</h3>'
            .'<p>Thank you. This job has been accepted. You may close this window.</p>'
            .'</body></html>';
    }

    // POST /vendor/dispatch/reject
    public function reject(): void
    {
        $token = trim((string)($_POST['token'] ?? ($_GET['token'] ?? '')));
        $d = $this->findDispatch($token);
        if (!$d) { http_response_code(400); echo 'Invalid or expired link'; return; }
        if ((string)($d['status'] ?? '') !== 'pending') { http_response_code(200); echo 'Already processed'; return; }
        $exp = strtotime((string)$d['expires_at']);
        if ($exp && $exp < time()) { $this->markExpired((int)$d['id']); echo 'Link expired'; return; }
        try {
            $this->pdo->beginTransaction();
            $ud = $this->pdo->prepare("UPDATE taxi_vendor_dispatch SET status='rejected', rejected_at=NOW() WHERE id=:id");
            $ud->execute([':id'=>(int)$d['id']]);
            $ev = $this->pdo->prepare('INSERT INTO taxi_booking_events (booking_id, user_id, event_type, note, data_json, created_at) VALUES (:bid, 0, \'vendor_rejected\', :note, :data, NOW())');
            $ev->execute([':bid'=>(int)$d['booking_id'], ':note'=>'Vendor rejected invitation', ':data'=>json_encode(['vendor_id'=>(int)$d['vendor_id'], 'ip'=>($_SERVER['REMOTE_ADDR'] ?? '')])]);
            $this->pdo->commit();
        } catch (\Throwable $e) { $this->pdo->rollBack(); }
        header('Content-Type: text/html; charset=UTF-8');
        echo '<!DOCTYPE html><html><body style="font-family:system-ui,Segoe UI,Arial,sans-serif;padding:24px;">'
            .'<h3>Invitation Rejected</h3>'
            .'<p>Your response has been recorded. You may close this window.</p>'
            .'</body></html>';
    }

    private function markExpired(int $id): void
    {
        try { $this->pdo->prepare("UPDATE taxi_vendor_dispatch SET status='expired' WHERE id=:id")->execute([':id'=>$id]); } catch (\Throwable $e) { }
    }
}
