<?php
namespace App\Controllers;

use App\Core\Controller;
use App\Core\Auth;

class TaxisController extends Controller
{
    public function index(): void
    {
        Auth::requireRole(['Admin']);
        $rows = $this->pdo->query("SELECT t.id, t.name, t.route, v.name AS vendor FROM taxis t JOIN vendors v ON v.id=t.vendor_id ORDER BY t.id DESC LIMIT 100")->fetchAll();
        $this->view('admin/vendors_taxi_list', ['rows' => $rows]);
    }
}
