<?php
namespace App\Controllers;

use App\Core\Controller;
use App\Core\Auth;
use App\Core\Security;

class PromoController extends Controller
{
    public function index(): void
    {
        Auth::requireRole(['Admin']);
        $rows = $this->pdo->query('SELECT * FROM promo_codes ORDER BY id DESC')->fetchAll();
        $dbName = $this->pdo->query('SELECT DATABASE()')->fetchColumn();
        $this->view('admin/promos/index', ['rows' => $rows, 'dbName' => $dbName, 'rowCount' => count($rows)]);
    }

    public function create(): void
    {
        Auth::requireRole(['Admin']);
        $csrf = Security::csrfToken();
        $this->view('admin/promos/form', ['csrf' => $csrf, 'mode' => 'create']);
    }

    public function store(): void
    {
        Auth::requireRole(['Admin']);
        Security::requireCsrf();
        $code = trim($_POST['code'] ?? '');
        $discountType = $_POST['discount_type'] ?? 'percent';
        $discountValue = (float)($_POST['discount_value'] ?? 0);
        $validFrom = $_POST['valid_from'] ?? null;
        $validTo = $_POST['valid_to'] ?? null;
        $usageLimit = !empty($_POST['usage_limit']) ? (int)$_POST['usage_limit'] : null;
        if ($code === '' || $discountValue <= 0 || !in_array($discountType, ['flat','percent'], true)) {
            $_SESSION['flash'] = 'Invalid form input.';
            $this->redirect('/admin/promos/create');
        }
        $stmt = $this->pdo->prepare('INSERT INTO promo_codes (code, discount_type, discount_value, valid_from, valid_to, usage_limit) VALUES (:c,:t,:v,:f,:to,:u)');
        $stmt->execute(['c'=>$code,'t'=>$discountType,'v'=>$discountValue,'f'=>$validFrom,'to'=>$validTo,'u'=>$usageLimit]);
        $_SESSION['flash'] = 'Promo created';
        $this->redirect('/admin/promos');
    }

    public function edit(): void
    {
        Auth::requireRole(['Admin']);
        $id = (int)($_GET['id'] ?? 0);
        $row = $this->pdo->prepare('SELECT * FROM promo_codes WHERE id=:id');
        $row->execute(['id'=>$id]);
        $promo = $row->fetch();
        if (!$promo) { $this->redirect('/admin/promos'); }
        $csrf = Security::csrfToken();
        $this->view('admin/promos/form', ['csrf'=>$csrf, 'mode'=>'edit', 'promo'=>$promo]);
    }

    public function update(): void
    {
        Auth::requireRole(['Admin']);
        Security::requireCsrf();
        $id = (int)($_POST['id'] ?? 0);
        $code = trim($_POST['code'] ?? '');
        $discountType = $_POST['discount_type'] ?? 'percent';
        $discountValue = (float)($_POST['discount_value'] ?? 0);
        $validFrom = $_POST['valid_from'] ?? null;
        $validTo = $_POST['valid_to'] ?? null;
        $usageLimit = !empty($_POST['usage_limit']) ? (int)$_POST['usage_limit'] : null;
        $stmt = $this->pdo->prepare('UPDATE promo_codes SET code=:c, discount_type=:t, discount_value=:v, valid_from=:f, valid_to=:to, usage_limit=:u WHERE id=:id');
        $stmt->execute(['c'=>$code,'t'=>$discountType,'v'=>$discountValue,'f'=>$validFrom,'to'=>$validTo,'u'=>$usageLimit,'id'=>$id]);
        $_SESSION['flash'] = 'Promo updated';
        $this->redirect('/admin/promos');
    }

    public function delete(): void
    {
        Auth::requireRole(['Admin']);
        Security::requireCsrf();
        $id = (int)($_POST['id'] ?? 0);
        $stmt = $this->pdo->prepare('DELETE FROM promo_codes WHERE id=:id');
        $stmt->execute(['id'=>$id]);
        $_SESSION['flash'] = 'Promo deleted';
        $this->redirect('/admin/promos');
    }
}
