<?php
namespace App\Controllers;

use App\Core\Controller;
use App\Core\Auth;
use App\Core\Security;

class CorporateController extends Controller
{
    public function index(): void
    {
        Auth::requireRole(['Admin']);
        $rows = $this->pdo->query('SELECT * FROM corporate_rates ORDER BY id DESC')->fetchAll();
        $this->view('admin/corporates/index', ['rows' => $rows]);
    }

    public function create(): void
    {
        Auth::requireRole(['Admin']);
        $csrf = Security::csrfToken();
        $this->view('admin/corporates/form', ['csrf' => $csrf, 'mode' => 'create']);
    }

    public function store(): void
    {
        Auth::requireRole(['Admin']);
        Security::requireCsrf();
        $company = trim($_POST['company_name'] ?? '');
        $discount = (float)($_POST['discount_percent'] ?? 0);
        if ($company === '' || $discount < 0) {
            $_SESSION['flash'] = 'Invalid form input.';
            $this->redirect('/admin/corporates/create');
        }
        $stmt = $this->pdo->prepare('INSERT INTO corporate_rates (company_name, discount_percent) VALUES (:n,:d)');
        $stmt->execute(['n'=>$company,'d'=>$discount]);
        $_SESSION['flash'] = 'Corporate account created';
        $this->redirect('/admin/corporates');
    }

    public function edit(): void
    {
        Auth::requireRole(['Admin']);
        $id = (int)($_GET['id'] ?? 0);
        $q = $this->pdo->prepare('SELECT * FROM corporate_rates WHERE id=:id');
        $q->execute(['id'=>$id]);
        $corp = $q->fetch();
        if (!$corp) { $this->redirect('/admin/corporates'); }
        $csrf = Security::csrfToken();
        $this->view('admin/corporates/form', ['csrf'=>$csrf, 'mode'=>'edit', 'corp'=>$corp]);
    }

    public function update(): void
    {
        Auth::requireRole(['Admin']);
        Security::requireCsrf();
        $id = (int)($_POST['id'] ?? 0);
        $company = trim($_POST['company_name'] ?? '');
        $discount = (float)($_POST['discount_percent'] ?? 0);
        $stmt = $this->pdo->prepare('UPDATE corporate_rates SET company_name=:n, discount_percent=:d WHERE id=:id');
        $stmt->execute(['n'=>$company,'d'=>$discount,'id'=>$id]);
        $_SESSION['flash'] = 'Corporate updated';
        $this->redirect('/admin/corporates');
    }

    public function delete(): void
    {
        Auth::requireRole(['Admin']);
        Security::requireCsrf();
        $id = (int)($_POST['id'] ?? 0);
        $stmt = $this->pdo->prepare('DELETE FROM corporate_rates WHERE id=:id');
        $stmt->execute(['id'=>$id]);
        $_SESSION['flash'] = 'Corporate deleted';
        $this->redirect('/admin/corporates');
    }
}
