<?php
namespace App\Controllers;

use App\Core\Controller;
use App\Core\Auth;

class CheckoutController extends Controller
{
    public function index(): void
    {
        Auth::requireRole(['B2B Agent']);
        $orderId = (int)($_GET['id'] ?? 0);
        $sig = (string)($_GET['sig'] ?? '');
        if ($orderId <= 0) {
            http_response_code(400);
            echo 'Missing order id';
            return;
        }
        // Ensure the order belongs to the current user
        $user = $_SESSION['user'] ?? null;
        if (!$user) { http_response_code(401); echo 'Unauthorized'; return; }
        $stmt = $this->pdo->prepare('SELECT id FROM orders WHERE id=:id AND user_id=:uid LIMIT 1');
        $stmt->execute(['id'=>$orderId,'uid'=>(int)$user['id']]);
        $own = $stmt->fetchColumn();
        if (!$own) { http_response_code(404); echo 'Not found'; return; }

        // Verify signed URL to mitigate ID enumeration
        $appKey = function_exists('env') ? (string)env('APP_KEY', '') : '';
        if ($appKey === '') { $appKey = getenv('APP_KEY') ?: 'devkey'; }
        $expected = hash_hmac('sha256', $orderId . ':' . (int)$user['id'], $appKey);
        if (!hash_equals($expected, $sig)) { http_response_code(403); echo 'Forbidden'; return; }

        // Security headers for sensitive page
        header('Cache-Control: no-store, max-age=0');
        header('Pragma: no-cache');
        header('X-Frame-Options: SAMEORIGIN');
        header("Content-Security-Policy: frame-ancestors 'self'");

        $this->view('checkout/index', [
            'title' => 'Checkout',
            'orderId' => $orderId,
            'sig' => $sig,
        ]);
    }

    public function pay(): void
    {
        Auth::requireRole(['B2B Agent']);
        $orderId = (int)($_GET['id'] ?? 0);
        $sig = (string)($_GET['sig'] ?? '');
        if ($orderId <= 0) {
            http_response_code(400);
            echo 'Missing order id';
            return;
        }
        $user = $_SESSION['user'] ?? null;
        if (!$user) { http_response_code(401); echo 'Unauthorized'; return; }
        $stmt = $this->pdo->prepare('SELECT id FROM orders WHERE id=:id AND user_id=:uid LIMIT 1');
        $stmt->execute(['id'=>$orderId,'uid'=>(int)$user['id']]);
        $own = $stmt->fetchColumn();
        if (!$own) { http_response_code(404); echo 'Not found'; return; }

        $appKey = function_exists('env') ? (string)env('APP_KEY', '') : '';
        if ($appKey === '') { $appKey = getenv('APP_KEY') ?: 'devkey'; }
        $expected = hash_hmac('sha256', $orderId . ':' . (int)$user['id'], $appKey);
        if (!hash_equals($expected, $sig)) { http_response_code(403); echo 'Forbidden'; return; }

        header('Cache-Control: no-store, max-age=0');
        header('Pragma: no-cache');
        header('X-Frame-Options: SAMEORIGIN');
        header("Content-Security-Policy: frame-ancestors 'self'");

        $this->view('checkout/pay', [
            'title' => 'Select Payment Method',
            'orderId' => $orderId,
            'sig' => $sig,
        ]);
    }

    public function confirm(): void
    {
        Auth::requireRole(['B2B Agent']);
        $orderId = (int)($_GET['id'] ?? 0);
        $sig = (string)($_GET['sig'] ?? '');
        if ($orderId <= 0) {
            http_response_code(400);
            echo 'Missing order id';
            return;
        }
        $user = $_SESSION['user'] ?? null;
        if (!$user) { http_response_code(401); echo 'Unauthorized'; return; }
        $stmt = $this->pdo->prepare('SELECT id FROM orders WHERE id=:id AND user_id=:uid LIMIT 1');
        $stmt->execute(['id'=>$orderId,'uid'=>(int)$user['id']]);
        $own = $stmt->fetchColumn();
        if (!$own) { http_response_code(404); echo 'Not found'; return; }

        $appKey = function_exists('env') ? (string)env('APP_KEY', '') : '';
        if ($appKey === '') { $appKey = getenv('APP_KEY') ?: 'devkey'; }
        $expected = hash_hmac('sha256', $orderId . ':' . (int)$user['id'], $appKey);
        if (!hash_equals($expected, $sig)) { http_response_code(403); echo 'Forbidden'; return; }

        header('Cache-Control: no-store, max-age=0');
        header('Pragma: no-cache');
        header('X-Frame-Options: SAMEORIGIN');
        header("Content-Security-Policy: frame-ancestors 'self'");

        $this->view('checkout/confirm', [
            'title' => 'Booking Confirmed',
            'orderId' => $orderId,
            'sig' => $sig,
        ]);
    }
}
